/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.web.tomcat;

import com.aoapps.collections.IntList;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.linux.PosixPath;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.web.tomcat.ContextDataSource;
import com.aoindustries.aoserv.client.web.tomcat.ContextParameter;
import com.aoindustries.aoserv.client.web.tomcat.Site;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class Context
extends CachedObjectIntegerKey<Context>
implements Removable {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_TOMCAT_SITE = 1;
    static final String COLUMN_TOMCAT_SITE_name = "tomcat_site";
    static final String COLUMN_PATH_name = "path";
    public static final String DEFAULT_CLASS_NAME = null;
    public static final boolean DEFAULT_COOKIES = true;
    public static final boolean DEFAULT_CROSS_CONTEXT = false;
    public static final boolean DEFAULT_OVERRIDE = false;
    public static final boolean DEFAULT_PRIVILEGED = false;
    public static final boolean DEFAULT_RELOADABLE = false;
    public static final boolean DEFAULT_USE_NAMING = true;
    public static final String DEFAULT_WRAPPER_CLASS = null;
    public static final int DEFAULT_DEBUG = 0;
    public static final PosixPath DEFAULT_WORK_DIR = null;
    public static final boolean DEFAULT_SERVER_XML_CONFIGURED = true;
    public static final String ROOT_PATH = "";
    public static final String ROOT_DOC_BASE = "ROOT";
    private int tomcatSite;
    private String className;
    private boolean cookies;
    private boolean crossContext;
    private PosixPath docBase;
    private boolean override;
    private String path;
    private boolean privileged;
    private boolean reloadable;
    private boolean useNaming;
    private String wrapperClass;
    private int debug;
    private PosixPath workDir;
    private boolean serverXmlConfigured;

    @Deprecated
    public Context() {
    }

    public int addHttpdTomcatDataSource(String name, String driverClassName, String url, String username, String password, int maxActive, int maxIdle, int maxWait, String validationQuery) throws IOException, SQLException {
        return this.table.getConnector().getWeb_tomcat().getContextDataSource().addHttpdTomcatDataSource(this, name, driverClassName, url, username, password, maxActive, maxIdle, maxWait, validationQuery);
    }

    public int addHttpdTomcatParameter(String name, String value, boolean override, String description) throws IOException, SQLException {
        return this.table.getConnector().getWeb_tomcat().getContextParameter().addHttpdTomcatParameter(this, name, value, override, description);
    }

    public List<CannotRemoveReason<Context>> getCannotRemoveReasons() {
        ArrayList<CannotRemoveReason<Context>> reasons = new ArrayList<CannotRemoveReason<Context>>();
        if (this.path.length() == 0) {
            reasons.add(new CannotRemoveReason<Context>("Not allowed to remove the root context", this));
        }
        return reasons;
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.tomcatSite;
            }
            case 2: {
                return this.className;
            }
            case 3: {
                return this.cookies;
            }
            case 4: {
                return this.crossContext;
            }
            case 5: {
                return this.docBase;
            }
            case 6: {
                return this.override;
            }
            case 7: {
                return this.path;
            }
            case 8: {
                return this.privileged;
            }
            case 9: {
                return this.reloadable;
            }
            case 10: {
                return this.useNaming;
            }
            case 11: {
                return this.wrapperClass;
            }
            case 12: {
                return this.debug;
            }
            case 13: {
                return this.workDir;
            }
            case 14: {
                return this.serverXmlConfigured;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public int getHttpdTomcatSite_httpdSite_id() {
        return this.tomcatSite;
    }

    public Site getHttpdTomcatSite() throws SQLException, IOException {
        Site obj = this.table.getConnector().getWeb_tomcat().getSite().get(this.tomcatSite);
        if (obj == null) {
            throw new SQLException("Unable to find HttpdTomcatSite: " + this.tomcatSite);
        }
        return obj;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean useCookies() {
        return this.cookies;
    }

    public boolean allowCrossContext() {
        return this.crossContext;
    }

    public PosixPath getDocBase() {
        return this.docBase;
    }

    public boolean allowOverride() {
        return this.override;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isPrivileged() {
        return this.privileged;
    }

    public boolean isReloadable() {
        return this.reloadable;
    }

    public boolean useNaming() {
        return this.useNaming;
    }

    public String getWrapperClass() {
        return this.wrapperClass;
    }

    public int getDebugLevel() {
        return this.debug;
    }

    public PosixPath getWorkDir() {
        return this.workDir;
    }

    public boolean isServerXmlConfigured() {
        return this.serverXmlConfigured;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.HTTPD_TOMCAT_CONTEXTS;
    }

    public List<ContextDataSource> getHttpdTomcatDataSources() throws IOException, SQLException {
        return this.table.getConnector().getWeb_tomcat().getContextDataSource().getHttpdTomcatDataSources(this);
    }

    public ContextDataSource getHttpdTomcatDataSource(String name) throws IOException, SQLException {
        return this.table.getConnector().getWeb_tomcat().getContextDataSource().getHttpdTomcatDataSource(this, name);
    }

    public List<ContextParameter> getHttpdTomcatParameters() throws IOException, SQLException {
        return this.table.getConnector().getWeb_tomcat().getContextParameter().getHttpdTomcatParameters(this);
    }

    public ContextParameter getHttpdTomcatParameter(String name) throws IOException, SQLException {
        return this.table.getConnector().getWeb_tomcat().getContextParameter().getHttpdTomcatParameter(this, name);
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = result.getInt(1);
            this.tomcatSite = result.getInt(2);
            this.className = result.getString(3);
            this.cookies = result.getBoolean(4);
            this.crossContext = result.getBoolean(5);
            this.docBase = PosixPath.valueOf(result.getString(6));
            this.override = result.getBoolean(7);
            this.path = result.getString(8);
            this.privileged = result.getBoolean(9);
            this.reloadable = result.getBoolean(10);
            this.useNaming = result.getBoolean(11);
            this.wrapperClass = result.getString(12);
            this.debug = result.getInt(13);
            this.workDir = PosixPath.valueOf(result.getString(14));
            this.serverXmlConfigured = result.getBoolean(15);
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    public static boolean isValidDocBase(PosixPath docBase) {
        String docBaseStr = docBase.toString();
        return docBaseStr.indexOf(34) == -1 && docBaseStr.indexOf(92) == -1 && docBaseStr.indexOf(10) == -1 && docBaseStr.indexOf(13) == -1;
    }

    public static boolean isValidPath(String path) {
        try {
            return path.length() == 0 || PosixPath.validate(path).isValid() && Context.isValidDocBase(PosixPath.valueOf(path));
        }
        catch (ValidationException e) {
            throw new AssertionError("Already validated", e);
        }
    }

    public static boolean isValidWorkDir(PosixPath workDir) {
        return workDir == null || Context.isValidDocBase(workDir);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.tomcatSite = in.readCompressedInt();
            this.className = in.readNullUTF();
            this.cookies = in.readBoolean();
            this.crossContext = in.readBoolean();
            this.docBase = PosixPath.valueOf(in.readUTF());
            this.override = in.readBoolean();
            this.path = in.readUTF();
            this.privileged = in.readBoolean();
            this.reloadable = in.readBoolean();
            this.useNaming = in.readBoolean();
            this.wrapperClass = in.readNullUTF();
            this.debug = in.readCompressedInt();
            this.workDir = PosixPath.valueOf(in.readNullUTF());
            this.serverXmlConfigured = in.readBoolean();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    public void setAttributes(final String className, final boolean cookies, final boolean crossContext, final PosixPath docBase, final boolean override, final String path, final boolean privileged, final boolean reloadable, final boolean useNaming, final String wrapperClass, final int debug, final PosixPath workDir, final boolean serverXmlConfigured) throws IOException, SQLException {
        this.table.getConnector().requestUpdate(true, AoservProtocol.CommandId.SET_HTTPD_TOMCAT_CONTEXT_ATTRIBUTES, new AoservConnector.UpdateRequest(){
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(Context.this.pkey);
                out.writeNullUTF(className);
                out.writeBoolean(cookies);
                out.writeBoolean(crossContext);
                out.writeUTF(docBase.toString());
                out.writeBoolean(override);
                out.writeUTF(path);
                out.writeBoolean(privileged);
                out.writeBoolean(reloadable);
                out.writeBoolean(useNaming);
                out.writeNullUTF(wrapperClass);
                out.writeCompressedInt(debug);
                out.writeNullUTF(Objects.toString(workDir, null));
                out.writeBoolean(serverXmlConfigured);
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public void afterRelease() {
                Context.this.table.getConnector().tablesUpdated(this.invalidateList);
            }
        });
    }

    @Override
    public void remove() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.HTTPD_TOMCAT_CONTEXTS, this.pkey});
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.tomcatSite);
        out.writeNullUTF(this.className);
        out.writeBoolean(this.cookies);
        out.writeBoolean(this.crossContext);
        out.writeUTF(this.docBase.toString());
        out.writeBoolean(this.override);
        out.writeUTF(this.path);
        out.writeBoolean(this.privileged);
        out.writeBoolean(this.reloadable);
        out.writeBoolean(this.useNaming);
        out.writeNullUTF(this.wrapperClass);
        out.writeCompressedInt(this.debug);
        out.writeNullUTF(Objects.toString(this.workDir, null));
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_81_3) >= 0) {
            out.writeBoolean(this.serverXmlConfigured);
        }
    }
}

