/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.web.tomcat;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.web.tomcat.Context;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;

public final class ContextDataSource
extends CachedObjectIntegerKey<ContextDataSource>
implements Removable {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_TOMCAT_CONTEXT = 1;
    static final String COLUMN_TOMCAT_CONTEXT_name = "tomcat_context";
    static final String COLUMN_NAME_name = "name";
    private int tomcatContext;
    private String name;
    private String driverClassName;
    private String url;
    private String username;
    private String password;
    private int maxActive;
    private int maxIdle;
    private int maxWait;
    private String validationQuery;

    @Deprecated
    public ContextDataSource() {
    }

    public List<CannotRemoveReason<?>> getCannotRemoveReasons() {
        return Collections.emptyList();
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.tomcatContext;
            }
            case 2: {
                return this.name;
            }
            case 3: {
                return this.driverClassName;
            }
            case 4: {
                return this.url;
            }
            case 5: {
                return this.username;
            }
            case 6: {
                return this.password;
            }
            case 7: {
                return this.maxActive;
            }
            case 8: {
                return this.maxIdle;
            }
            case 9: {
                return this.maxWait;
            }
            case 10: {
                return this.validationQuery;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public Context getHttpdTomcatContext() throws SQLException, IOException {
        Context obj = this.table.getConnector().getWeb_tomcat().getContext().get(this.tomcatContext);
        if (obj == null) {
            throw new SQLException("Unable to find HttpdTomcatContext: " + this.tomcatContext);
        }
        return obj;
    }

    public String getName() {
        return this.name;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public int getMaxWait() {
        return this.maxWait;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.HTTPD_TOMCAT_DATA_SOURCES;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getInt(1);
        this.tomcatContext = result.getInt(2);
        this.name = result.getString(3);
        this.driverClassName = result.getString(4);
        this.url = result.getString(5);
        this.username = result.getString(6);
        this.password = result.getString(7);
        this.maxActive = result.getInt(8);
        this.maxIdle = result.getInt(9);
        this.maxWait = result.getInt(10);
        this.validationQuery = result.getString(11);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.tomcatContext = in.readCompressedInt();
        this.name = in.readUTF();
        this.driverClassName = in.readUTF();
        this.url = in.readUTF();
        this.username = in.readUTF().intern();
        this.password = in.readUTF();
        this.maxActive = in.readCompressedInt();
        this.maxIdle = in.readCompressedInt();
        this.maxWait = in.readCompressedInt();
        this.validationQuery = in.readNullUTF();
    }

    @Override
    public void remove() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.HTTPD_TOMCAT_DATA_SOURCES, this.pkey});
    }

    public void update(String name, String driverClassName, String url, String username, String password, int maxActive, int maxIdle, int maxWait, String validationQuery) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.UPDATE_HTTPD_TOMCAT_DATA_SOURCE, this.pkey, name, driverClassName, url, username, password, maxActive, maxIdle, maxWait, validationQuery == null ? "" : validationQuery);
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.tomcatContext);
        out.writeUTF(this.name);
        out.writeUTF(this.driverClassName);
        out.writeUTF(this.url);
        out.writeUTF(this.username);
        out.writeUTF(this.password);
        out.writeCompressedInt(this.maxActive);
        out.writeCompressedInt(this.maxIdle);
        out.writeCompressedInt(this.maxWait);
        out.writeNullUTF(this.validationQuery);
    }
}

