/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.web.tomcat;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.web.tomcat.Context;
import com.aoindustries.aoserv.client.web.tomcat.ContextDataSource;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.List;

public final class ContextDataSourceTable
extends CachedTableIntegerKey<ContextDataSource> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("tomcat_context.tomcat_site.httpd_site.name", true), new AoservTable.OrderBy("tomcat_context.tomcat_site.httpd_site.ao_server.hostname", true), new AoservTable.OrderBy("tomcat_context.path", true), new AoservTable.OrderBy("name", true)};

    ContextDataSourceTable(AoservConnector connector) {
        super(connector, ContextDataSource.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    int addHttpdTomcatDataSource(Context htc, String name, String driverClassName, String url, String username, String password, int maxActive, int maxIdle, int maxWait, String validationQuery) throws IOException, SQLException {
        return this.connector.requestIntQueryInvalidating(true, AoservProtocol.CommandId.ADD, new Object[]{Table.TableId.HTTPD_TOMCAT_DATA_SOURCES, htc.getPkey(), name, driverClassName, url, username, password, maxActive, maxIdle, maxWait, validationQuery == null ? "" : validationQuery});
    }

    @Override
    public ContextDataSource get(int pkey) throws IOException, SQLException {
        return (ContextDataSource)this.getUniqueRow(0, pkey);
    }

    List<ContextDataSource> getHttpdTomcatDataSources(Context htc) throws IOException, SQLException {
        return this.getIndexedRows(1, htc.getPkey());
    }

    ContextDataSource getHttpdTomcatDataSource(Context htc, String name) throws IOException, SQLException {
        List<ContextDataSource> dataSources = this.getHttpdTomcatDataSources(htc);
        for (ContextDataSource dataSource : dataSources) {
            if (!dataSource.getName().equals(name)) continue;
            return dataSource;
        }
        return null;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.HTTPD_TOMCAT_DATA_SOURCES;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_httpd_tomcat_data_source")) {
            if (Aosh.checkParamCount("add_httpd_tomcat_data_source", args, 12, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().addHttpdTomcatDataSource(args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], Aosh.parseInt(args[9], "max_active"), Aosh.parseInt(args[10], "max_idle"), Aosh.parseInt(args[11], "max_wait"), args[12]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("remove_httpd_tomcat_data_source")) {
            if (Aosh.checkParamCount("remove_httpd_tomcat_data_source", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().removeHttpdTomcatDataSource(Aosh.parseInt(args[1], "pkey"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("update_httpd_tomcat_data_source")) {
            if (Aosh.checkParamCount("update_httpd_tomcat_data_source", args, 13, (PrintWriter)err)) {
                this.connector.getSimpleClient().updateHttpdTomcatDataSource(args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9], Aosh.parseInt(args[10], "max_active"), Aosh.parseInt(args[11], "max_idle"), Aosh.parseInt(args[12], "max_wait"), args[13]);
            }
            return true;
        }
        return false;
    }
}

