/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.web.tomcat;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.web.tomcat.Context;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;

public final class ContextParameter
extends CachedObjectIntegerKey<ContextParameter>
implements Removable {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_TOMCAT_CONTEXT = 1;
    static final String COLUMN_TOMCAT_CONTEXT_name = "tomcat_context";
    static final String COLUMN_NAME_name = "name";
    private int tomcatContext;
    private String name;
    private String value;
    private boolean override;
    private String description;

    @Deprecated
    public ContextParameter() {
    }

    public List<CannotRemoveReason<?>> getCannotRemoveReasons() {
        return Collections.emptyList();
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.tomcatContext;
            }
            case 2: {
                return this.name;
            }
            case 3: {
                return this.value;
            }
            case 4: {
                return this.override;
            }
            case 5: {
                return this.description;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public Context getHttpdTomcatContext() throws SQLException, IOException {
        Context obj = this.table.getConnector().getWeb_tomcat().getContext().get(this.tomcatContext);
        if (obj == null) {
            throw new SQLException("Unable to find HttpdTomcatContext: " + this.tomcatContext);
        }
        return obj;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean getOverride() {
        return this.override;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.HTTPD_TOMCAT_PARAMETERS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getInt(1);
        this.tomcatContext = result.getInt(2);
        this.name = result.getString(3);
        this.value = result.getString(4);
        this.override = result.getBoolean(5);
        this.description = result.getString(6);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.tomcatContext = in.readCompressedInt();
        this.name = in.readUTF();
        this.value = in.readUTF();
        this.override = in.readBoolean();
        this.description = in.readNullUTF();
    }

    @Override
    public void remove() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.HTTPD_TOMCAT_PARAMETERS, this.pkey});
    }

    public void update(String name, String value, boolean override, String description) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.UPDATE_HTTPD_TOMCAT_PARAMETER, this.pkey, name, value, override, description == null ? "" : description);
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.tomcatContext);
        out.writeUTF(this.name);
        out.writeUTF(this.value);
        out.writeBoolean(this.override);
        out.writeNullUTF(this.description);
    }
}

