/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.web.tomcat;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.web.tomcat.Context;
import com.aoindustries.aoserv.client.web.tomcat.ContextParameter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.List;

public final class ContextParameterTable
extends CachedTableIntegerKey<ContextParameter> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("tomcat_context.tomcat_site.httpd_site.name", true), new AoservTable.OrderBy("tomcat_context.tomcat_site.httpd_site.ao_server.hostname", true), new AoservTable.OrderBy("tomcat_context.path", true), new AoservTable.OrderBy("name", true)};

    ContextParameterTable(AoservConnector connector) {
        super(connector, ContextParameter.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    int addHttpdTomcatParameter(Context htc, String name, String value, boolean override, String description) throws IOException, SQLException {
        return this.connector.requestIntQueryInvalidating(true, AoservProtocol.CommandId.ADD, new Object[]{Table.TableId.HTTPD_TOMCAT_PARAMETERS, htc.getPkey(), name, value, override, description == null ? "" : description});
    }

    @Override
    public ContextParameter get(int pkey) throws IOException, SQLException {
        return (ContextParameter)this.getUniqueRow(0, pkey);
    }

    List<ContextParameter> getHttpdTomcatParameters(Context htc) throws IOException, SQLException {
        return this.getIndexedRows(1, htc.getPkey());
    }

    ContextParameter getHttpdTomcatParameter(Context htc, String name) throws IOException, SQLException {
        List<ContextParameter> parameters = this.getHttpdTomcatParameters(htc);
        for (ContextParameter parameter : parameters) {
            if (!parameter.getName().equals(name)) continue;
            return parameter;
        }
        return null;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.HTTPD_TOMCAT_PARAMETERS;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_httpd_tomcat_parameter")) {
            if (Aosh.checkParamCount("add_httpd_tomcat_parameter", args, 7, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().addHttpdTomcatParameter(args[1], args[2], args[3], args[4], args[5], Aosh.parseBoolean(args[6], "override"), args[7]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("remove_httpd_tomcat_parameter")) {
            if (Aosh.checkParamCount("remove_httpd_tomcat_parameter", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().removeHttpdTomcatParameter(Aosh.parseInt(args[1], "pkey"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("update_httpd_tomcat_parameter")) {
            if (Aosh.checkParamCount("update_httpd_tomcat_parameter", args, 8, (PrintWriter)err)) {
                this.connector.getSimpleClient().updateHttpdTomcatParameter(args[1], args[2], args[3], args[4], args[5], args[6], Aosh.parseBoolean(args[7], "override"), args[8]);
            }
            return true;
        }
        return false;
    }
}

