/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.web.tomcat;

import com.aoapps.collections.IntList;
import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.linux.PosixPath;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.web.tomcat.Context;
import com.aoindustries.aoserv.client.web.tomcat.Site;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;

public final class ContextTable
extends CachedTableIntegerKey<Context> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("tomcat_site.httpd_site.name", true), new AoservTable.OrderBy("tomcat_site.httpd_site.ao_server.hostname", true), new AoservTable.OrderBy("path", true)};

    ContextTable(AoservConnector connector) {
        super(connector, Context.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    int addHttpdTomcatContext(final Site hts, final String className, final boolean cookies, final boolean crossContext, final PosixPath docBase, final boolean override, final String path, final boolean privileged, final boolean reloadable, final boolean useNaming, final String wrapperClass, final int debug, final PosixPath workDir, final boolean serverXmlConfigured) throws IOException, SQLException {
        return this.connector.requestResult(true, AoservProtocol.CommandId.ADD, new AoservConnector.ResultRequest<Integer>(){
            private int pkey;
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(Table.TableId.HTTPD_TOMCAT_CONTEXTS.ordinal());
                out.writeCompressedInt(hts.getPkey());
                out.writeNullUTF(className);
                out.writeBoolean(cookies);
                out.writeBoolean(crossContext);
                out.writeUTF(docBase.toString());
                out.writeBoolean(override);
                out.writeUTF(path);
                out.writeBoolean(privileged);
                out.writeBoolean(reloadable);
                out.writeBoolean(useNaming);
                out.writeNullUTF(wrapperClass);
                out.writeCompressedInt(debug);
                out.writeNullUTF(Objects.toString(workDir, null));
                out.writeBoolean(serverXmlConfigured);
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.pkey = in.readCompressedInt();
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public Integer afterRelease() {
                ContextTable.this.connector.tablesUpdated(this.invalidateList);
                return this.pkey;
            }
        });
    }

    @Override
    public Context get(int pkey) throws IOException, SQLException {
        return (Context)this.getUniqueRow(0, pkey);
    }

    Context getHttpdTomcatContext(Site hts, String path) throws IOException, SQLException {
        int hts_id = hts.getPkey();
        List cached = this.getRows();
        int size = cached.size();
        for (int c = 0; c < size; ++c) {
            Context htc = (Context)cached.get(c);
            if (htc.getHttpdTomcatSite_httpdSite_id() != hts_id || !htc.getPath().equals(path)) continue;
            return htc;
        }
        return null;
    }

    List<Context> getHttpdTomcatContexts(Site hts) throws IOException, SQLException {
        return this.getIndexedRows(1, hts.getPkey());
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.HTTPD_TOMCAT_CONTEXTS;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_httpd_tomcat_context")) {
            if (Aosh.checkParamCount("add_httpd_tomcat_context", args, 15, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().addHttpdTomcatContext(args[1], args[2], args[3], Aosh.parseBoolean(args[4], "use_cookies"), Aosh.parseBoolean(args[5], "cross_context"), Aosh.parseUnixPath(args[6], "doc_base"), Aosh.parseBoolean(args[7], "allow_override"), args[8], Aosh.parseBoolean(args[9], "is_privileged"), Aosh.parseBoolean(args[10], "is_reloadable"), Aosh.parseBoolean(args[11], "use_naming"), args[12], Aosh.parseInt(args[13], "debug_level"), args[14].isEmpty() ? null : Aosh.parseUnixPath(args[14], "work_dir"), Aosh.parseBoolean(args[15], "server_xml_configured")));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("remove_httpd_tomcat_context")) {
            if (Aosh.checkParamCount("remove_httpd_tomcat_context", args, 1, (PrintWriter)err)) {
                this.connector.getSimpleClient().removeHttpdTomcatContext(Aosh.parseInt(args[1], "pkey"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_httpd_tomcat_context_attributes")) {
            if (Aosh.checkParamCount("set_httpd_tomcat_context_attributes", args, 16, (PrintWriter)err)) {
                this.connector.getSimpleClient().setHttpdTomcatContextAttributes(args[1], args[2], args[3], args[4], Aosh.parseBoolean(args[5], "use_cookies"), Aosh.parseBoolean(args[6], "cross_context"), Aosh.parseUnixPath(args[7], "doc_base"), Aosh.parseBoolean(args[8], "allow_override"), args[9], Aosh.parseBoolean(args[10], "is_privileged"), Aosh.parseBoolean(args[11], "is_reloadable"), Aosh.parseBoolean(args[12], "use_naming"), args[13], Aosh.parseInt(args[14], "debug_level"), args[15].isEmpty() ? null : Aosh.parseUnixPath(args[15], "work_dir"), Aosh.parseBoolean(args[16], "server_xml_configured"));
            }
            return true;
        }
        return false;
    }
}

