/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.web.tomcat;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.web.tomcat.Site;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;

public final class JkMount
extends CachedObjectIntegerKey<JkMount>
implements Removable {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_HTTPD_TOMCAT_SITE = 1;
    static final String COLUMN_HTTPD_TOMCAT_SITE_name = "httpd_tomcat_site";
    static final String COLUMN_PATH_name = "path";
    static final String COLUMN_MOUNT_name = "mount";
    private int httpdTomcatSite;
    private String path;
    private boolean mount;

    public static boolean isValidPath(String path) {
        return path.length() > 1 && path.charAt(0) == '/' && !path.contains("//") && !path.contains("..") && path.indexOf(34) == -1 && path.indexOf(92) == -1 && path.indexOf(10) == -1 && path.indexOf(13) == -1 && path.indexOf(0) == -1;
    }

    @Deprecated
    public JkMount() {
    }

    public List<CannotRemoveReason<?>> getCannotRemoveReasons() {
        return Collections.emptyList();
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.httpdTomcatSite;
            }
            case 2: {
                return this.path;
            }
            case 3: {
                return this.mount;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public Site getHttpdTomcatSite() throws SQLException, IOException {
        Site obj = this.table.getConnector().getWeb_tomcat().getSite().get(this.httpdTomcatSite);
        if (obj == null) {
            throw new SQLException("Unable to find HttpdTomcatSite: " + this.httpdTomcatSite);
        }
        return obj;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isMount() {
        return this.mount;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.HTTPD_TOMCAT_SITE_JK_MOUNTS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getInt(1);
        this.httpdTomcatSite = result.getInt(2);
        this.path = result.getString(3);
        this.mount = result.getBoolean(4);
        if (!JkMount.isValidPath(this.path)) {
            throw new SQLException("Invalid path: " + this.path);
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.httpdTomcatSite = in.readCompressedInt();
        this.path = in.readUTF();
        this.mount = in.readBoolean();
        if (!JkMount.isValidPath(this.path)) {
            throw new IOException("Invalid path: " + this.path);
        }
    }

    @Override
    public String toStringImpl() {
        return (this.mount ? "JkMount " : "JkUnMount ") + this.path;
    }

    @Override
    public void remove() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.HTTPD_TOMCAT_SITE_JK_MOUNTS, this.pkey});
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.httpdTomcatSite);
        out.writeUTF(this.path);
        out.writeBoolean(this.mount);
    }
}

