/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.web.tomcat;

import com.aoapps.collections.IntList;
import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.web.tomcat.JkMount;
import com.aoindustries.aoserv.client.web.tomcat.Site;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.List;

public final class JkMountTable
extends CachedTableIntegerKey<JkMount> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("httpd_tomcat_site.httpd_site.name", true), new AoservTable.OrderBy("httpd_tomcat_site.httpd_site.ao_server.hostname", true), new AoservTable.OrderBy("mount", false), new AoservTable.OrderBy("path", true)};

    JkMountTable(AoservConnector connector) {
        super(connector, JkMount.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    int addHttpdTomcatSiteJkMount(final Site hts, final String path, final boolean mount) throws IOException, SQLException {
        if (!JkMount.isValidPath(path)) {
            throw new IllegalArgumentException("Invalid path: " + path);
        }
        return this.connector.requestResult(true, AoservProtocol.CommandId.ADD, new AoservConnector.ResultRequest<Integer>(){
            private int pkey;
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(Table.TableId.HTTPD_TOMCAT_SITE_JK_MOUNTS.ordinal());
                out.writeCompressedInt(hts.getPkey());
                out.writeUTF(path);
                out.writeBoolean(mount);
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.pkey = in.readCompressedInt();
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public Integer afterRelease() {
                JkMountTable.this.connector.tablesUpdated(this.invalidateList);
                return this.pkey;
            }
        });
    }

    @Override
    public JkMount get(int pkey) throws IOException, SQLException {
        return (JkMount)this.getUniqueRow(0, pkey);
    }

    List<JkMount> getHttpdTomcatSiteJkMounts(Site tomcatSite) throws IOException, SQLException {
        return this.getIndexedRows(1, tomcatSite.getPkey());
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.HTTPD_TOMCAT_SITE_JK_MOUNTS;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_httpd_tomcat_site_jk_mount")) {
            if (Aosh.checkParamCount("add_httpd_tomcat_site_jk_mount", args, 4, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().addHttpdTomcatSiteJkMount(args[1], args[2], args[3], Aosh.parseBoolean(args[4], "mount")));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("remove_httpd_tomcat_site_jk_mount")) {
            if (Aosh.checkParamCount("remove_httpd_tomcat_site_jk_mount", args, 3, (PrintWriter)err)) {
                this.connector.getSimpleClient().removeHttpdTomcatSiteJkMount(args[1], args[2], args[3]);
            }
            return true;
        }
        return false;
    }
}

