/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.web.tomcat;

import com.aoapps.collections.IntList;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.net.Bind;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.web.tomcat.Site;
import com.aoindustries.aoserv.client.web.tomcat.Version;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class PrivateTomcatSite
extends CachedObjectIntegerKey<PrivateTomcatSite> {
    static final int COLUMN_TOMCAT_SITE = 0;
    static final int COLUMN_TOMCAT4_SHUTDOWN_PORT = 1;
    static final String COLUMN_TOMCAT_SITE_name = "tomcat_site";
    public static final int DEFAULT_MAX_POST_SIZE = 0x1000000;
    public static final String DEFAULT_TOMCAT_VERSION_PREFIX = "10.1.";
    private int tomcat4ShutdownPort;
    private String tomcat4ShutdownKey;
    private int maxPostSize;
    private boolean unpackWars;
    private boolean autoDeploy;
    private boolean tomcatAuthentication;

    @Deprecated
    public PrivateTomcatSite() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.tomcat4ShutdownPort == -1 ? null : Integer.valueOf(this.tomcat4ShutdownPort);
            }
            case 2: {
                return this.tomcat4ShutdownKey;
            }
            case 3: {
                return this.maxPostSize == -1 ? null : Integer.valueOf(this.maxPostSize);
            }
            case 4: {
                return this.unpackWars;
            }
            case 5: {
                return this.autoDeploy;
            }
            case 6: {
                return this.tomcatAuthentication;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public Site getHttpdTomcatSite() throws SQLException, IOException {
        Site obj = this.table.getConnector().getWeb_tomcat().getSite().get(this.pkey);
        if (obj == null) {
            throw new SQLException("Unable to find HttpdTomcatSite: " + this.pkey);
        }
        return obj;
    }

    public String getTomcat4ShutdownKey() {
        return this.tomcat4ShutdownKey;
    }

    public int getMaxPostSize() {
        return this.maxPostSize;
    }

    public void setMaxPostSize(final int maxPostSize) throws IOException, SQLException {
        this.table.getConnector().requestUpdate(true, AoservProtocol.CommandId.SET_HTTPD_TOMCAT_STD_SITE_MAX_POST_SIZE, new AoservConnector.UpdateRequest(){
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(PrivateTomcatSite.this.pkey);
                out.writeInt(maxPostSize);
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public void afterRelease() {
                PrivateTomcatSite.this.table.getConnector().tablesUpdated(this.invalidateList);
            }
        });
    }

    public boolean getUnpackWars() {
        return this.unpackWars;
    }

    public void setUnpackWars(boolean unpackWars) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_HTTPD_TOMCAT_STD_SITE_UNPACK_WARS, this.pkey, unpackWars);
    }

    public boolean getAutoDeploy() {
        return this.autoDeploy;
    }

    public void setAutoDeploy(boolean autoDeploy) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_HTTPD_TOMCAT_STD_SITE_AUTO_DEPLOY, this.pkey, autoDeploy);
    }

    public boolean getTomcatAuthentication() {
        return this.tomcatAuthentication;
    }

    public void setTomcatAuthentication(boolean tomcatAuthentication) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.web_tomcat_PrivateTomcatSite_tomcatAuthentication_set, this.pkey, tomcatAuthentication);
    }

    public Integer getTomcat4ShutdownPort_id() {
        return this.tomcat4ShutdownPort == -1 ? null : Integer.valueOf(this.tomcat4ShutdownPort);
    }

    public Bind getTomcat4ShutdownPort() throws IOException, SQLException {
        if (this.tomcat4ShutdownPort == -1) {
            return null;
        }
        Bind nb = this.table.getConnector().getNet().getBind().get(this.tomcat4ShutdownPort);
        if (nb == null) {
            throw new SQLException("Unable to find NetBind: " + this.tomcat4ShutdownPort);
        }
        return nb;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.HTTPD_TOMCAT_STD_SITES;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getInt(1);
        this.tomcat4ShutdownPort = result.getInt(2);
        if (result.wasNull()) {
            this.tomcat4ShutdownPort = -1;
        }
        this.tomcat4ShutdownKey = result.getString(3);
        this.maxPostSize = result.getInt(4);
        if (result.wasNull()) {
            this.maxPostSize = -1;
        }
        this.unpackWars = result.getBoolean(5);
        this.autoDeploy = result.getBoolean(6);
        this.tomcatAuthentication = result.getBoolean(7);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.tomcat4ShutdownPort = in.readCompressedInt();
        this.tomcat4ShutdownKey = in.readNullUTF();
        this.maxPostSize = in.readInt();
        this.unpackWars = in.readBoolean();
        this.autoDeploy = in.readBoolean();
        this.tomcatAuthentication = in.readBoolean();
    }

    @Override
    public String toStringImpl() throws SQLException, IOException {
        return this.getHttpdTomcatSite().toStringImpl();
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.tomcat4ShutdownPort);
        out.writeNullUTF(this.tomcat4ShutdownKey);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_80_1) >= 0) {
            out.writeInt(this.maxPostSize);
            out.writeBoolean(this.unpackWars);
            out.writeBoolean(this.autoDeploy);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_2) >= 0) {
            out.writeBoolean(this.tomcatAuthentication);
        }
    }

    public void setHttpdTomcatVersion(Version version) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_HTTPD_TOMCAT_STD_SITE_VERSION, this.pkey, version.getPkey());
    }
}

