/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.web.tomcat;

import com.aoapps.collections.IntList;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.CannotRemoveReason;
import com.aoindustries.aoserv.client.Disablable;
import com.aoindustries.aoserv.client.Removable;
import com.aoindustries.aoserv.client.account.DisableLog;
import com.aoindustries.aoserv.client.linux.GroupServer;
import com.aoindustries.aoserv.client.linux.PosixPath;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.linux.UserServer;
import com.aoindustries.aoserv.client.net.Bind;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.web.Site;
import com.aoindustries.aoserv.client.web.tomcat.SharedTomcatSite;
import com.aoindustries.aoserv.client.web.tomcat.Version;
import com.aoindustries.aoserv.client.web.tomcat.Worker;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class SharedTomcat
extends CachedObjectIntegerKey<SharedTomcat>
implements Disablable,
Removable {
    static final int COLUMN_PKEY = 0;
    static final int COLUMN_AO_SERVER = 2;
    static final int COLUMN_LINUX_SERVER_ACCOUNT = 4;
    static final int COLUMN_TOMCAT4_WORKER = 7;
    static final int COLUMN_TOMCAT4_SHUTDOWN_PORT = 8;
    static final String COLUMN_NAME_name = "name";
    static final String COLUMN_AO_SERVER_name = "ao_server";
    public static final int DEFAULT_MAX_POST_SIZE = 0x1000000;
    public static final int MAX_NAME_LENGTH = 32;
    public static final String DEFAULT_TOMCAT_VERSION_PREFIX = "10.1.";
    private String name;
    private int aoServer;
    private int version;
    private int linuxServerAccount;
    private int linuxServerGroup;
    private int disableLog;
    private int tomcat4Worker;
    private int tomcat4ShutdownPort;
    private String tomcat4ShutdownKey;
    private boolean isManual;
    private int maxPostSize;
    private boolean unpackWars;
    private boolean autoDeploy;
    private boolean tomcatAuthentication;

    @Deprecated
    public SharedTomcat() {
    }

    @Override
    public boolean canDisable() {
        return this.disableLog == -1;
    }

    @Override
    public boolean canEnable() throws SQLException, IOException {
        DisableLog dl = this.getDisableLog();
        if (dl == null) {
            return false;
        }
        return dl.canEnable() && !this.getLinuxServerGroup().getLinuxGroup().getPackage().isDisabled() && !this.getLinuxServerAccount().isDisabled();
    }

    public List<CannotRemoveReason<SharedTomcatSite>> getCannotRemoveReasons() throws SQLException, IOException {
        ArrayList<CannotRemoveReason<SharedTomcatSite>> reasons = new ArrayList<CannotRemoveReason<SharedTomcatSite>>();
        for (SharedTomcatSite htss : this.getHttpdTomcatSharedSites()) {
            Site hs = htss.getHttpdTomcatSite().getHttpdSite();
            reasons.add(new CannotRemoveReason<SharedTomcatSite>("Used by Multi-Site Tomcat website " + hs.getInstallDirectory() + " on " + hs.getLinuxServer().getHostname(), htss));
        }
        return reasons;
    }

    @Override
    public void disable(DisableLog dl) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.DISABLE, new Object[]{Table.TableId.HTTPD_SHARED_TOMCATS, dl.getPkey(), this.pkey});
    }

    @Override
    public void enable() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.ENABLE, new Object[]{Table.TableId.HTTPD_SHARED_TOMCATS, this.pkey});
    }

    public PosixPath getInstallDirectory() throws SQLException, IOException {
        try {
            return PosixPath.valueOf(this.getLinuxServer().getHost().getOperatingSystemVersion().getHttpdSharedTomcatsDirectory().toString() + '/' + this.name);
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.name;
            }
            case 2: {
                return this.aoServer;
            }
            case 3: {
                return this.version;
            }
            case 4: {
                return this.linuxServerAccount;
            }
            case 5: {
                return this.linuxServerGroup;
            }
            case 6: {
                return this.disableLog == -1 ? null : Integer.valueOf(this.disableLog);
            }
            case 7: {
                return this.tomcat4Worker == -1 ? null : Integer.valueOf(this.tomcat4Worker);
            }
            case 8: {
                return this.tomcat4ShutdownPort == -1 ? null : Integer.valueOf(this.tomcat4ShutdownPort);
            }
            case 9: {
                return this.tomcat4ShutdownKey;
            }
            case 10: {
                return this.isManual;
            }
            case 11: {
                return this.maxPostSize == -1 ? null : Integer.valueOf(this.maxPostSize);
            }
            case 12: {
                return this.unpackWars;
            }
            case 13: {
                return this.autoDeploy;
            }
            case 14: {
                return this.tomcatAuthentication;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    @Override
    public boolean isDisabled() {
        return this.disableLog != -1;
    }

    @Override
    public DisableLog getDisableLog() throws SQLException, IOException {
        if (this.disableLog == -1) {
            return null;
        }
        DisableLog obj = this.table.getConnector().getAccount().getDisableLog().get(this.disableLog);
        if (obj == null) {
            throw new SQLException("Unable to find DisableLog: " + this.disableLog);
        }
        return obj;
    }

    public List<SharedTomcatSite> getHttpdTomcatSharedSites() throws IOException, SQLException {
        return this.table.getConnector().getWeb_tomcat().getSharedTomcatSite().getHttpdTomcatSharedSites(this);
    }

    public Version getHttpdTomcatVersion() throws SQLException, IOException {
        Version obj = this.table.getConnector().getWeb_tomcat().getVersion().get(this.version);
        if (obj == null) {
            throw new SQLException("Unable to find HttpdTomcatVersion: " + this.version);
        }
        if (obj.getTechnologyVersion(this.table.getConnector()).getOperatingSystemVersion(this.table.getConnector()).getPkey() != this.getLinuxServer().getHost().getOperatingSystemVersion_id()) {
            throw new SQLException("resource/operating system version mismatch on HttpdSharedTomcat: #" + this.pkey);
        }
        return obj;
    }

    public void setHttpdTomcatVersion(Version version) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_HTTPD_SHARED_TOMCAT_VERSION, this.pkey, version.getPkey());
    }

    public int getLinuxServerAccount_pkey() {
        return this.linuxServerAccount;
    }

    public UserServer getLinuxServerAccount() throws SQLException, IOException {
        UserServer obj = this.table.getConnector().getLinux().getUserServer().get(this.linuxServerAccount);
        if (obj == null) {
            throw new SQLException("Unable to find LinuxServerAccount: " + this.linuxServerAccount);
        }
        return obj;
    }

    public int getLinuxServerGroup_pkey() {
        return this.linuxServerGroup;
    }

    public GroupServer getLinuxServerGroup() throws SQLException, IOException {
        GroupServer obj = this.table.getConnector().getLinux().getGroupServer().get(this.linuxServerGroup);
        if (obj == null) {
            throw new SQLException("Unable to find LinuxServerGroup: " + this.linuxServerGroup);
        }
        return obj;
    }

    public String getName() {
        return this.name;
    }

    public Server getLinuxServer() throws SQLException, IOException {
        Server obj = this.table.getConnector().getLinux().getServer().get(this.aoServer);
        if (obj == null) {
            throw new SQLException("Unable to find linux.Server: " + this.aoServer);
        }
        return obj;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.HTTPD_SHARED_TOMCATS;
    }

    public Worker getTomcat4Worker() throws SQLException, IOException {
        if (this.tomcat4Worker == -1) {
            return null;
        }
        Worker hw = this.table.getConnector().getWeb_tomcat().getWorker().get(this.tomcat4Worker);
        if (hw == null) {
            throw new SQLException("Unable to find HttpdWorker: " + this.tomcat4Worker);
        }
        return hw;
    }

    public String getTomcat4ShutdownKey() {
        return this.tomcat4ShutdownKey;
    }

    public Bind getTomcat4ShutdownPort() throws IOException, SQLException {
        if (this.tomcat4ShutdownPort == -1) {
            return null;
        }
        Bind nb = this.table.getConnector().getNet().getBind().get(this.tomcat4ShutdownPort);
        if (nb == null) {
            throw new SQLException("Unable to find NetBind: " + this.tomcat4ShutdownPort);
        }
        return nb;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        int pos = 1;
        this.pkey = result.getInt(pos++);
        this.name = result.getString(pos++);
        this.aoServer = result.getInt(pos++);
        this.version = result.getInt(pos++);
        this.linuxServerAccount = result.getInt(pos++);
        this.linuxServerGroup = result.getInt(pos++);
        this.disableLog = result.getInt(pos++);
        if (result.wasNull()) {
            this.disableLog = -1;
        }
        this.tomcat4Worker = result.getInt(pos++);
        if (result.wasNull()) {
            this.tomcat4Worker = -1;
        }
        this.tomcat4ShutdownPort = result.getInt(pos++);
        if (result.wasNull()) {
            this.tomcat4ShutdownPort = -1;
        }
        this.tomcat4ShutdownKey = result.getString(pos++);
        this.isManual = result.getBoolean(pos++);
        this.maxPostSize = result.getInt(pos++);
        if (result.wasNull()) {
            this.maxPostSize = -1;
        }
        this.unpackWars = result.getBoolean(pos++);
        this.autoDeploy = result.getBoolean(pos++);
        this.tomcatAuthentication = result.getBoolean(pos++);
    }

    public boolean isManual() {
        return this.isManual;
    }

    public void setIsManual(boolean isManual) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_HTTPD_SHARED_TOMCAT_IS_MANUAL, this.pkey, isManual);
    }

    public int getMaxPostSize() {
        return this.maxPostSize;
    }

    public void setMaxPostSize(final int maxPostSize) throws IOException, SQLException {
        this.table.getConnector().requestUpdate(true, AoservProtocol.CommandId.SET_HTTPD_SHARED_TOMCAT_MAX_POST_SIZE, new AoservConnector.UpdateRequest(){
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(SharedTomcat.this.pkey);
                out.writeInt(maxPostSize);
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public void afterRelease() {
                SharedTomcat.this.table.getConnector().tablesUpdated(this.invalidateList);
            }
        });
    }

    public boolean getUnpackWars() {
        return this.unpackWars;
    }

    public void setUnpackWars(boolean unpackWars) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_HTTPD_SHARED_TOMCAT_UNPACK_WARS, this.pkey, unpackWars);
    }

    public boolean getAutoDeploy() {
        return this.autoDeploy;
    }

    public void setAutoDeploy(boolean autoDeploy) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_HTTPD_SHARED_TOMCAT_AUTO_DEPLOY, this.pkey, autoDeploy);
    }

    public boolean getTomcatAuthentication() {
        return this.tomcatAuthentication;
    }

    public void setTomcatAuthentication(boolean tomcatAuthentication) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.web_tomcat_SharedTomcat_tomcatAuthentication_set, this.pkey, tomcatAuthentication);
    }

    public static boolean isValidSharedTomcatName(String name) {
        if ("lost+found".equals(name) || "aquota.group".equals(name) || "aquota.user".equals(name)) {
            return false;
        }
        int len = name.length();
        if (len == 0 || len > 32) {
            return false;
        }
        char ch = name.charAt(0);
        if (ch < 'a' || ch > 'z') {
            return false;
        }
        for (int c = 1; c < len; ++c) {
            ch = name.charAt(c);
            if (ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '-') continue;
            return false;
        }
        return true;
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.name = in.readUTF();
        this.aoServer = in.readCompressedInt();
        this.version = in.readCompressedInt();
        this.linuxServerAccount = in.readCompressedInt();
        this.linuxServerGroup = in.readCompressedInt();
        this.disableLog = in.readCompressedInt();
        this.tomcat4Worker = in.readCompressedInt();
        this.tomcat4ShutdownPort = in.readCompressedInt();
        this.tomcat4ShutdownKey = in.readNullUTF();
        this.isManual = in.readBoolean();
        this.maxPostSize = in.readInt();
        this.unpackWars = in.readBoolean();
        this.autoDeploy = in.readBoolean();
        this.tomcatAuthentication = in.readBoolean();
    }

    @Override
    public void remove() throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.REMOVE, new Object[]{Table.TableId.HTTPD_SHARED_TOMCATS, this.pkey});
    }

    @Override
    public String toStringImpl() throws SQLException, IOException {
        return this.name + " on " + this.getLinuxServer().getHostname();
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeUTF(this.name);
        out.writeCompressedInt(this.aoServer);
        out.writeCompressedInt(this.version);
        out.writeCompressedInt(this.linuxServerAccount);
        out.writeCompressedInt(this.linuxServerGroup);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_81_9) <= 0) {
            out.writeBoolean(false);
            out.writeBoolean(false);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_30) <= 0) {
            out.writeShort(0);
            out.writeShort(7);
            out.writeShort(0);
            out.writeShort(7);
            out.writeShort(0);
            out.writeShort(7);
        }
        out.writeCompressedInt(this.disableLog);
        out.writeCompressedInt(this.tomcat4Worker);
        out.writeCompressedInt(this.tomcat4ShutdownPort);
        out.writeNullUTF(this.tomcat4ShutdownKey);
        out.writeBoolean(this.isManual);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_80_1) >= 0) {
            out.writeInt(this.maxPostSize);
            out.writeBoolean(this.unpackWars);
            out.writeBoolean(this.autoDeploy);
        }
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_83_2) >= 0) {
            out.writeBoolean(this.tomcatAuthentication);
        }
    }
}

