/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.web.tomcat;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.web.tomcat.SharedTomcat;
import com.aoindustries.aoserv.client.web.tomcat.Site;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class SharedTomcatSite
extends CachedObjectIntegerKey<SharedTomcatSite> {
    static final int COLUMN_TOMCAT_SITE = 0;
    static final int COLUMN_HTTPD_SHARED_TOMCAT = 1;
    static final String COLUMN_TOMCAT_SITE_name = "tomcat_site";
    private int httpdSharedTomcat;
    public static final String DEFAULT_TOMCAT_VERSION_PREFIX = "10.1.";

    @Deprecated
    public SharedTomcatSite() {
    }

    public boolean canStop() throws SQLException, IOException {
        SharedTomcat hst = this.getHttpdSharedTomcat();
        return this.getHttpdSharedTomcat() != null && !hst.isDisabled();
    }

    public boolean canStart() throws SQLException, IOException {
        if (this.getHttpdTomcatSite().getHttpdSite().isDisabled()) {
            return false;
        }
        SharedTomcat hst = this.getHttpdSharedTomcat();
        if (hst == null) {
            return true;
        }
        return !hst.isDisabled();
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.httpdSharedTomcat;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public SharedTomcat getHttpdSharedTomcat() throws SQLException, IOException {
        return this.table.getConnector().getWeb_tomcat().getSharedTomcat().get(this.httpdSharedTomcat);
    }

    public Site getHttpdTomcatSite() throws SQLException, IOException {
        Site obj = this.table.getConnector().getWeb_tomcat().getSite().get(this.pkey);
        if (obj == null) {
            throw new SQLException("Unable to find HttpdTomcatSite: " + this.pkey);
        }
        return obj;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.HTTPD_TOMCAT_SHARED_SITES;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getInt(1);
        this.httpdSharedTomcat = result.getInt(2);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.httpdSharedTomcat = in.readCompressedInt();
    }

    @Override
    public String toStringImpl() throws SQLException, IOException {
        return this.getHttpdTomcatSite().toStringImpl();
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.httpdSharedTomcat);
    }
}

