/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.web.tomcat;

import com.aoapps.collections.IntList;
import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.SimpleAoservClient;
import com.aoindustries.aoserv.client.account.Account;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.billing.Package;
import com.aoindustries.aoserv.client.linux.GroupServer;
import com.aoindustries.aoserv.client.linux.Server;
import com.aoindustries.aoserv.client.linux.UserServer;
import com.aoindustries.aoserv.client.net.Bind;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.web.tomcat.SharedTomcat;
import com.aoindustries.aoserv.client.web.tomcat.Version;
import com.aoindustries.aoserv.client.web.tomcat.Worker;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class SharedTomcatTable
extends CachedTableIntegerKey<SharedTomcat> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("name", true), new AoservTable.OrderBy("ao_server.hostname", true)};

    SharedTomcatTable(AoservConnector connector) {
        super(connector, SharedTomcat.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    public int addHttpdSharedTomcat(final String name, final Server aoServer, Version version, final UserServer lsa, final GroupServer lsg) throws IOException, SQLException {
        final int tvPkey = version.getTechnologyVersion(this.connector).getPkey();
        return this.connector.requestResult(true, AoservProtocol.CommandId.ADD, new AoservConnector.ResultRequest<Integer>(){
            private int pkey;
            private IntList invalidateList;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(Table.TableId.HTTPD_SHARED_TOMCATS.ordinal());
                out.writeUTF(name);
                out.writeCompressedInt(aoServer.getPkey());
                out.writeCompressedInt(tvPkey);
                out.writeUTF(lsa.getLinuxAccount_username_id().toString());
                out.writeUTF(lsg.getLinuxGroup_name().toString());
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code != 1) {
                    AoservProtocol.checkResult(code, in);
                    throw new IOException("Unexpected response code: " + code);
                }
                this.pkey = in.readCompressedInt();
                this.invalidateList = AoservConnector.readInvalidateList(in);
            }

            @Override
            public Integer afterRelease() {
                SharedTomcatTable.this.connector.tablesUpdated(this.invalidateList);
                return this.pkey;
            }
        });
    }

    public String generateSharedTomcatName(String template) throws IOException, SQLException {
        return this.connector.requestStringQuery(true, AoservProtocol.CommandId.GENERATE_SHARED_TOMCAT_NAME, template);
    }

    @Override
    public SharedTomcat get(int pkey) throws SQLException, IOException {
        return (SharedTomcat)this.getUniqueRow(0, pkey);
    }

    public SharedTomcat getHttpdSharedTomcat(Worker hw) throws SQLException, IOException {
        return (SharedTomcat)this.getUniqueRow(7, hw.getPkey());
    }

    public SharedTomcat getHttpdSharedTomcatByShutdownPort(Bind nb) throws SQLException, IOException {
        return (SharedTomcat)this.getUniqueRow(8, nb.getId());
    }

    public List<SharedTomcat> getHttpdSharedTomcats(UserServer lsa) throws IOException, SQLException {
        return this.getIndexedRows(4, lsa.getPkey());
    }

    public List<SharedTomcat> getHttpdSharedTomcats(Package pk) throws IOException, SQLException {
        Account.Name pkname = pk.getName();
        List cached = this.getRows();
        int size = cached.size();
        ArrayList<SharedTomcat> matches = new ArrayList<SharedTomcat>(size);
        for (int c = 0; c < size; ++c) {
            SharedTomcat hst = (SharedTomcat)cached.get(c);
            if (!hst.getLinuxServerGroup().getLinuxGroup().getPackage_name().equals(pkname)) continue;
            matches.add(hst);
        }
        return matches;
    }

    public List<SharedTomcat> getHttpdSharedTomcats(Server ao) throws IOException, SQLException {
        return this.getIndexedRows(2, ao.getPkey());
    }

    public SharedTomcat getHttpdSharedTomcat(String name, Server ao) throws IOException, SQLException {
        List<SharedTomcat> cached = this.getHttpdSharedTomcats(ao);
        int size = cached.size();
        for (int c = 0; c < size; ++c) {
            SharedTomcat tomcat = cached.get(c);
            if (!tomcat.getName().equals(name)) continue;
            return tomcat;
        }
        return null;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.HTTPD_SHARED_TOMCATS;
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, SQLException, IOException {
        String command = args[0];
        if (command.equalsIgnoreCase("add_httpd_shared_tomcat")) {
            if (Aosh.checkMinParamCount("add_httpd_shared_tomcat", args, 5, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().addHttpdSharedTomcat(args[1], args[2], args[3], Aosh.parseLinuxUserName(args[4], "linux_server_account"), Aosh.parseGroupName(args[5], "linux_server_group")));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("check_shared_tomcat_name")) {
            if (Aosh.checkParamCount("check_shared_tomcat_name", args, 1, (PrintWriter)err)) {
                try {
                    SimpleAoservClient.checkSharedTomcatName(args[1]);
                    out.println("true");
                }
                catch (IllegalArgumentException iae) {
                    out.print("aosh: check_shared_tomcat_name: ");
                    out.println(iae.getMessage());
                }
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("disable_httpd_shared_tomcat")) {
            if (Aosh.checkParamCount("disable_httpd_shared_tomcat", args, 3, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().disableHttpdSharedTomcat(args[1], args[2], args[3]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("enable_httpd_shared_tomcat")) {
            if (Aosh.checkParamCount("enable_httpd_shared_tomcat", args, 2, (PrintWriter)err)) {
                this.connector.getSimpleClient().enableHttpdSharedTomcat(args[1], args[2]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("generate_shared_tomcat_name")) {
            if (Aosh.checkParamCount("generate_shared_tomcat_name", args, 1, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().generateSharedTomcatName(args[1]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("is_shared_tomcat_name_available")) {
            if (Aosh.checkParamCount("is_shared_tomcat_name_available", args, 1, (PrintWriter)err)) {
                out.println(this.connector.getSimpleClient().isSharedTomcatNameAvailable(args[1]));
                out.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("remove_httpd_shared_tomcat")) {
            if (Aosh.checkParamCount("remove_httpd_shared_tomcat", args, 2, (PrintWriter)err)) {
                this.connector.getSimpleClient().removeHttpdSharedTomcat(args[1], args[2]);
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_httpd_shared_tomcat_is_manual")) {
            if (Aosh.checkParamCount("set_httpd_shared_tomcat_is_manual", args, 3, (PrintWriter)err)) {
                this.connector.getSimpleClient().setHttpdSharedTomcatIsManual(args[1], args[2], Aosh.parseBoolean(args[3], "is_manual"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_httpd_shared_tomcat_max_post_size")) {
            if (Aosh.checkParamCount("set_httpd_shared_tomcat_max_post_size", args, 3, (PrintWriter)err)) {
                this.connector.getSimpleClient().setHttpdSharedTomcatMaxPostSize(args[1], args[2], args[3].isEmpty() ? -1 : Aosh.parseInt(args[3], "max_post_size"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_httpd_shared_tomcat_unpack_wars")) {
            if (Aosh.checkParamCount("set_httpd_shared_tomcat_unpack_wars", args, 3, (PrintWriter)err)) {
                this.connector.getSimpleClient().setHttpdSharedTomcatIsManual(args[1], args[2], Aosh.parseBoolean(args[3], "unpack_wars"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_httpd_shared_tomcat_auto_deploy")) {
            if (Aosh.checkParamCount("set_httpd_shared_tomcat_auto_deploy", args, 3, (PrintWriter)err)) {
                this.connector.getSimpleClient().setHttpdSharedTomcatAutoDeploy(args[1], args[2], Aosh.parseBoolean(args[3], "auto_deploy"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("web.tomcat.SharedTomcat.tomcatAuthentication.set")) {
            if (Aosh.checkParamCount("web.tomcat.SharedTomcat.tomcatAuthentication.set", args, 3, (PrintWriter)err)) {
                this.connector.getSimpleClient().setHttpdSharedTomcatTomcatAuthentication(args[1], args[2], Aosh.parseBoolean(args[3], "tomcatAuthentication"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("set_httpd_shared_tomcat_version")) {
            if (Aosh.checkParamCount("set_httpd_shared_tomcat_version", args, 3, (PrintWriter)err)) {
                this.connector.getSimpleClient().setHttpdSharedTomcatVersion(args[1], args[2], args[3]);
            }
            return true;
        }
        return false;
    }

    public boolean isSharedTomcatNameAvailable(String name) throws IOException, SQLException {
        return this.connector.requestBooleanQuery(true, AoservProtocol.CommandId.IS_SHARED_TOMCAT_NAME_AVAILABLE, name);
    }
}

