/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.web.tomcat;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.linux.PosixPath;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.web.tomcat.Context;
import com.aoindustries.aoserv.client.web.tomcat.JkMount;
import com.aoindustries.aoserv.client.web.tomcat.PrivateTomcatSite;
import com.aoindustries.aoserv.client.web.tomcat.SharedTomcatSite;
import com.aoindustries.aoserv.client.web.tomcat.Version;
import com.aoindustries.aoserv.client.web.tomcat.Worker;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public final class Site
extends CachedObjectIntegerKey<Site> {
    static final int COLUMN_HTTPD_SITE = 0;
    public static final String COLUMN_HTTPD_SITE_name = "httpd_site";
    private int version;
    private boolean blockWebinf;
    private boolean useApache;
    public static final int MINIMUM_START_JVM_DELAY = 30000;
    public static final int MINIMUM_STOP_JVM_DELAY = 15000;

    @Deprecated
    public Site() {
    }

    public int addHttpdTomcatContext(String className, boolean cookies, boolean crossContext, PosixPath docBase, boolean override, String path, boolean privileged, boolean reloadable, boolean useNaming, String wrapperClass, int debug, PosixPath workDir, boolean serverXmlConfigured) throws IOException, SQLException {
        return this.table.getConnector().getWeb_tomcat().getContext().addHttpdTomcatContext(this, className, cookies, crossContext, docBase, override, path, privileged, reloadable, useNaming, wrapperClass, debug, workDir, serverXmlConfigured);
    }

    public int addJkMount(String path, boolean mount) throws IOException, SQLException {
        return this.table.getConnector().getWeb_tomcat().getJkMount().addHttpdTomcatSiteJkMount(this, path, mount);
    }

    public boolean canStop() throws SQLException, IOException {
        if (this.getHttpdSite().isDisabled()) {
            return false;
        }
        SharedTomcatSite shr = this.getHttpdTomcatSharedSite();
        if (shr != null) {
            return shr.canStop();
        }
        return true;
    }

    public boolean canStart() throws SQLException, IOException {
        if (this.getHttpdSite().isDisabled()) {
            return false;
        }
        SharedTomcatSite shr = this.getHttpdTomcatSharedSite();
        if (shr != null) {
            return shr.canStart();
        }
        return true;
    }

    @Override
    protected Object getColumnImpl(int i) {
        if (i == 0) {
            return this.pkey;
        }
        if (i == 1) {
            return this.version;
        }
        if (i == 2) {
            return this.blockWebinf;
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public com.aoindustries.aoserv.client.web.jboss.Site getHttpdJbossSite() throws SQLException, IOException {
        return this.table.getConnector().getWeb_jboss().getSite().get(this.pkey);
    }

    public com.aoindustries.aoserv.client.web.Site getHttpdSite() throws SQLException, IOException {
        com.aoindustries.aoserv.client.web.Site obj = this.table.getConnector().getWeb().getSite().get(this.pkey);
        if (obj == null) {
            throw new SQLException("Unable to find HttpdSite: " + this.pkey);
        }
        return obj;
    }

    public Context getHttpdTomcatContext(String path) throws IOException, SQLException {
        return this.table.getConnector().getWeb_tomcat().getContext().getHttpdTomcatContext(this, path);
    }

    public List<Context> getHttpdTomcatContexts() throws IOException, SQLException {
        return this.table.getConnector().getWeb_tomcat().getContext().getHttpdTomcatContexts(this);
    }

    public SharedTomcatSite getHttpdTomcatSharedSite() throws IOException, SQLException {
        return this.table.getConnector().getWeb_tomcat().getSharedTomcatSite().get(this.pkey);
    }

    public PrivateTomcatSite getHttpdTomcatStdSite() throws IOException, SQLException {
        return this.table.getConnector().getWeb_tomcat().getPrivateTomcatSite().get(this.pkey);
    }

    public Version getHttpdTomcatVersion() throws SQLException, IOException {
        Version obj = this.table.getConnector().getWeb_tomcat().getVersion().get(this.version);
        if (obj == null) {
            throw new SQLException("Unable to find HttpdTomcatVersion: " + this.version);
        }
        if (obj.getTechnologyVersion(this.table.getConnector()).getOperatingSystemVersion(this.table.getConnector()).getPkey() != this.getHttpdSite().getLinuxServer().getHost().getOperatingSystemVersion_id()) {
            throw new SQLException("resource/operating system version mismatch on HttpdTomcatSite: #" + this.pkey);
        }
        SharedTomcatSite sharedSite = this.getHttpdTomcatSharedSite();
        if (sharedSite != null && obj.getPkey() != sharedSite.getHttpdSharedTomcat().getHttpdTomcatVersion().getPkey()) {
            throw new SQLException("HttpdTomcatSite/HttpdSharedTomcat version mismatch on HttpdTomcatSite: #" + this.pkey);
        }
        return obj;
    }

    public List<Worker> getHttpdWorkers() throws IOException, SQLException {
        return this.table.getConnector().getWeb_tomcat().getWorker().getHttpdWorkers(this);
    }

    public List<JkMount> getJkMounts() throws IOException, SQLException {
        return this.table.getConnector().getWeb_tomcat().getJkMount().getHttpdTomcatSiteJkMounts(this);
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.HTTPD_TOMCAT_SITES;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        this.pkey = result.getInt(1);
        this.version = result.getInt(2);
        this.blockWebinf = result.getBoolean(3);
        this.useApache = result.getBoolean(4);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.version = in.readCompressedInt();
        this.blockWebinf = in.readBoolean();
    }

    public String startJvm() throws IOException, SQLException {
        return this.table.getConnector().requestResult(false, AoservProtocol.CommandId.START_JVM, new AoservConnector.ResultRequest<String>(){
            private String result;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(Site.this.pkey);
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code == 1) {
                    this.result = in.readNullUTF();
                    return;
                }
                AoservProtocol.checkResult(code, in);
                throw new IOException("Unexpected response code: " + code);
            }

            @Override
            public String afterRelease() {
                return this.result;
            }
        });
    }

    public String stopJvm() throws IOException, SQLException {
        return this.table.getConnector().requestResult(false, AoservProtocol.CommandId.STOP_JVM, new AoservConnector.ResultRequest<String>(){
            private String result;

            @Override
            public void writeRequest(StreamableOutput out) throws IOException {
                out.writeCompressedInt(Site.this.pkey);
            }

            @Override
            public void readResponse(StreamableInput in) throws IOException, SQLException {
                byte code = in.readByte();
                if (code == 1) {
                    this.result = in.readNullUTF();
                    return;
                }
                AoservProtocol.checkResult(code, in);
                throw new IOException("Unexpected response code: " + code);
            }

            @Override
            public String afterRelease() {
                return this.result;
            }
        });
    }

    @Override
    public String toStringImpl() throws SQLException, IOException {
        return this.getHttpdSite().toStringImpl();
    }

    public boolean getBlockWebinf() {
        return this.blockWebinf;
    }

    public void setBlockWebinf(boolean blockWebinf) throws IOException, SQLException {
        this.table.getConnector().requestUpdateInvalidating(true, AoservProtocol.CommandId.SET_HTTPD_TOMCAT_SITE_BLOCK_WEBINF, this.pkey, blockWebinf);
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeCompressedInt(this.version);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_81_6) >= 0) {
            out.writeBoolean(this.blockWebinf);
        } else {
            out.writeBoolean(this.useApache);
        }
    }
}

