/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.web.tomcat;

import com.aoapps.hodgepodge.io.TerminalWriter;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.aosh.Aosh;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.web.tomcat.Site;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.SQLException;

public final class SiteTable
extends CachedTableIntegerKey<Site> {
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("httpd_site.name", true), new AoservTable.OrderBy("httpd_site.ao_server.hostname", true)};

    SiteTable(AoservConnector connector) {
        super(connector, Site.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.HTTPD_TOMCAT_SITES;
    }

    @Override
    public Site get(int pkey) throws IOException, SQLException {
        return (Site)this.getUniqueRow(0, pkey);
    }

    @Override
    public boolean handleCommand(String[] args, Reader in, TerminalWriter out, TerminalWriter err, boolean isInteractive) throws IllegalArgumentException, IOException, SQLException {
        String command = args[0];
        if (command.equalsIgnoreCase("set_httpd_tomcat_site_block_webinf")) {
            if (Aosh.checkParamCount("set_httpd_tomcat_site_block_webinf", args, 3, (PrintWriter)err)) {
                this.connector.getSimpleClient().setHttpdTomcatSiteBlockWebinf(args[1], args[2], Aosh.parseBoolean(args[3], "block_webinf"));
            }
            return true;
        }
        if (command.equalsIgnoreCase("start_jvm")) {
            String message;
            if (Aosh.checkParamCount("start_jvm", args, 2, (PrintWriter)err) && (message = this.connector.getSimpleClient().startJvm(args[1], args[2])) != null) {
                err.println("aosh: start_jvm: " + message);
                err.flush();
            }
            return true;
        }
        if (command.equalsIgnoreCase("stop_jvm")) {
            String message;
            if (Aosh.checkParamCount("stop_jvm", args, 2, (PrintWriter)err) && (message = this.connector.getSimpleClient().stopJvm(args[1], args[2])) != null) {
                err.println("aosh: stop_jvm: " + message);
                err.flush();
            }
            return true;
        }
        return false;
    }
}

