/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.web.tomcat;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoapps.lang.validation.ValidationException;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.GlobalObjectIntegerKey;
import com.aoindustries.aoserv.client.distribution.SoftwareVersion;
import com.aoindustries.aoserv.client.linux.PosixPath;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class Version
extends GlobalObjectIntegerKey<Version> {
    static final int COLUMN_VERSION = 0;
    static final String COLUMN_VERSION_name = "version";
    private PosixPath installDir;
    private boolean requiresModJk;
    public static final String TECHNOLOGY_NAME = "jakarta-tomcat";
    public static final String VERSION_3_1 = "3.1";
    public static final String VERSION_3_2_4 = "3.2.4";
    public static final String VERSION_4_1_PREFIX = "4.1.";
    public static final String VERSION_5_5_PREFIX = "5.5.";
    public static final String VERSION_6_0_PREFIX = "6.0.";
    public static final String VERSION_7_0_PREFIX = "7.0.";
    public static final String VERSION_8_0_PREFIX = "8.0.";
    public static final String VERSION_8_5_PREFIX = "8.5.";
    public static final String VERSION_9_0_PREFIX = "9.0.";
    public static final String VERSION_10_0_PREFIX = "10.0.";
    public static final String VERSION_10_1_PREFIX = "10.1.";

    public static boolean canUpgradeFrom(String version) {
        return !version.equals(VERSION_3_1) && !version.equals(VERSION_3_2_4);
    }

    public static boolean canUpgradeTo(String version) {
        return !version.equals(VERSION_3_1) && !version.equals(VERSION_3_2_4) && !version.startsWith(VERSION_4_1_PREFIX) && !version.startsWith(VERSION_5_5_PREFIX) && !version.startsWith(VERSION_6_0_PREFIX) && !version.startsWith(VERSION_7_0_PREFIX) && !version.startsWith(VERSION_8_0_PREFIX);
    }

    @Deprecated
    public Version() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.installDir;
            }
            case 2: {
                return this.requiresModJk;
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public PosixPath getInstallDirectory() {
        return this.installDir;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.HTTPD_TOMCAT_VERSIONS;
    }

    public SoftwareVersion getTechnologyVersion(AoservConnector connector) throws SQLException, IOException {
        SoftwareVersion obj = connector.getDistribution().getSoftwareVersion().get(this.pkey);
        if (obj == null) {
            throw new SQLException("Unable to find TechnologyVersion: " + this.pkey);
        }
        return obj;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        try {
            this.pkey = result.getInt(1);
            this.installDir = PosixPath.valueOf(result.getString(2));
            this.requiresModJk = result.getBoolean(3);
        }
        catch (ValidationException e) {
            throw new SQLException(e);
        }
    }

    @Deprecated
    public boolean isTomcat4(AoservConnector connector) throws SQLException, IOException {
        String version = this.getTechnologyVersion(connector).getVersion();
        return version.startsWith("4.") || version.startsWith("5.");
    }

    public boolean isTomcat3_1(AoservConnector connector) throws SQLException, IOException {
        String version = this.getTechnologyVersion(connector).getVersion();
        return version.equals(VERSION_3_1);
    }

    public boolean isTomcat3_2_4(AoservConnector connector) throws SQLException, IOException {
        String version = this.getTechnologyVersion(connector).getVersion();
        return version.equals(VERSION_3_2_4);
    }

    public boolean isTomcat4_1_X(AoservConnector connector) throws SQLException, IOException {
        String version = this.getTechnologyVersion(connector).getVersion();
        return version.startsWith(VERSION_4_1_PREFIX);
    }

    public boolean isTomcat5_5_X(AoservConnector connector) throws SQLException, IOException {
        String version = this.getTechnologyVersion(connector).getVersion();
        return version.startsWith(VERSION_5_5_PREFIX);
    }

    public boolean isTomcat6_0_X(AoservConnector connector) throws SQLException, IOException {
        String version = this.getTechnologyVersion(connector).getVersion();
        return version.startsWith(VERSION_6_0_PREFIX);
    }

    public boolean isTomcat7_0_X(AoservConnector connector) throws SQLException, IOException {
        String version = this.getTechnologyVersion(connector).getVersion();
        return version.startsWith(VERSION_7_0_PREFIX);
    }

    public boolean isTomcat8_0_X(AoservConnector connector) throws SQLException, IOException {
        String version = this.getTechnologyVersion(connector).getVersion();
        return version.startsWith(VERSION_8_0_PREFIX);
    }

    public boolean isTomcat8_5_X(AoservConnector connector) throws SQLException, IOException {
        String version = this.getTechnologyVersion(connector).getVersion();
        return version.startsWith(VERSION_8_5_PREFIX);
    }

    public boolean isTomcat9_0_X(AoservConnector connector) throws SQLException, IOException {
        String version = this.getTechnologyVersion(connector).getVersion();
        return version.startsWith(VERSION_9_0_PREFIX);
    }

    public boolean isTomcat10_0_X(AoservConnector connector) throws SQLException, IOException {
        String version = this.getTechnologyVersion(connector).getVersion();
        return version.startsWith(VERSION_10_0_PREFIX);
    }

    public boolean isTomcat10_1_X(AoservConnector connector) throws SQLException, IOException {
        String version = this.getTechnologyVersion(connector).getVersion();
        return version.startsWith(VERSION_10_1_PREFIX);
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        try {
            this.pkey = in.readCompressedInt();
            this.installDir = PosixPath.valueOf(in.readUTF());
            this.requiresModJk = in.readBoolean();
        }
        catch (ValidationException e) {
            throw new IOException(e);
        }
    }

    public boolean requiresModjK() {
        return this.requiresModJk;
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeUTF(this.installDir.toString());
        out.writeBoolean(this.requiresModJk);
    }
}

