/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.web.tomcat;

import com.aoapps.hodgepodge.io.stream.StreamableInput;
import com.aoapps.hodgepodge.io.stream.StreamableOutput;
import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.CachedObjectIntegerKey;
import com.aoindustries.aoserv.client.net.AppProtocol;
import com.aoindustries.aoserv.client.net.Bind;
import com.aoindustries.aoserv.client.schema.AoservProtocol;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.web.tomcat.JkProtocol;
import com.aoindustries.aoserv.client.web.tomcat.SharedTomcat;
import com.aoindustries.aoserv.client.web.tomcat.Site;
import com.aoindustries.aoserv.client.web.tomcat.WorkerName;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class Worker
extends CachedObjectIntegerKey<Worker> {
    static final int COLUMN_BIND = 0;
    static final int COLUMN_TOMCAT_SITE = 2;
    static final String COLUMN_BIND_name = "bind";
    static final String COLUMN_NAME_name = "name";
    private String name;
    private int tomcatSite;

    @Deprecated
    public Worker() {
    }

    @Override
    protected Object getColumnImpl(int i) {
        switch (i) {
            case 0: {
                return this.pkey;
            }
            case 1: {
                return this.name;
            }
            case 2: {
                return this.tomcatSite == -1 ? null : Integer.valueOf(this.tomcatSite);
            }
        }
        throw new IllegalArgumentException("Invalid index: " + i);
    }

    public int getBind_id() {
        return this.pkey;
    }

    public Bind getBind() throws IOException, SQLException {
        Bind obj = this.table.getConnector().getNet().getBind().get(this.pkey);
        if (obj == null) {
            throw new SQLException("Unable to find NetBind: " + this.pkey);
        }
        return obj;
    }

    public String getName_code() {
        return this.name;
    }

    public WorkerName getName() throws SQLException, IOException {
        WorkerName obj = this.table.getConnector().getWeb_tomcat().getWorkerName().get(this.name);
        if (obj == null) {
            throw new SQLException("Unable to find HttpdJKCode: " + this.name);
        }
        return obj;
    }

    public int getTomcatSite_httpdSite() {
        return this.tomcatSite;
    }

    public Site getTomcatSite() throws SQLException, IOException {
        if (this.tomcatSite == -1) {
            return null;
        }
        Site obj = this.table.getConnector().getWeb_tomcat().getSite().get(this.tomcatSite);
        if (obj == null) {
            throw new SQLException("Unable to find HttpdTomcatSite: " + this.tomcatSite);
        }
        return obj;
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.HTTPD_WORKERS;
    }

    @Override
    public void init(ResultSet result) throws SQLException {
        int pos = 1;
        this.pkey = result.getInt(pos++);
        this.name = result.getString(pos++);
        this.tomcatSite = result.getInt(pos++);
        if (result.wasNull()) {
            this.tomcatSite = -1;
        }
    }

    @Override
    public void read(StreamableInput in, AoservProtocol.Version protocolVersion) throws IOException {
        this.pkey = in.readCompressedInt();
        this.name = in.readUTF();
        this.tomcatSite = in.readCompressedInt();
    }

    @Override
    public void write(StreamableOutput out, AoservProtocol.Version protocolVersion) throws IOException {
        out.writeCompressedInt(this.pkey);
        out.writeUTF(this.name);
        if (protocolVersion.compareTo(AoservProtocol.Version.VERSION_1_81_17) <= 0) {
            out.writeCompressedInt(this.pkey);
        }
        out.writeCompressedInt(this.tomcatSite);
    }

    @Override
    public String toStringImpl() {
        return this.pkey + "|" + this.name;
    }

    public JkProtocol getHttpdJkProtocol(AoservConnector connector) throws IOException, SQLException {
        AppProtocol appProtocol = this.getBind().getAppProtocol();
        JkProtocol obj = appProtocol.getHttpdJkProtocol(connector);
        if (obj == null) {
            throw new SQLException("Unable to find HttpdJkProtocol: " + appProtocol);
        }
        return obj;
    }

    public SharedTomcat getHttpdSharedTomcat() throws SQLException, IOException {
        return this.table.getConnector().getWeb_tomcat().getSharedTomcat().getHttpdSharedTomcat(this);
    }
}

