/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.aoserv.client.web.tomcat;

import com.aoindustries.aoserv.client.AoservConnector;
import com.aoindustries.aoserv.client.AoservTable;
import com.aoindustries.aoserv.client.CachedTableIntegerKey;
import com.aoindustries.aoserv.client.net.Bind;
import com.aoindustries.aoserv.client.schema.Table;
import com.aoindustries.aoserv.client.web.HttpdServer;
import com.aoindustries.aoserv.client.web.VirtualHost;
import com.aoindustries.aoserv.client.web.tomcat.SharedTomcat;
import com.aoindustries.aoserv.client.web.tomcat.SharedTomcatSite;
import com.aoindustries.aoserv.client.web.tomcat.Site;
import com.aoindustries.aoserv.client.web.tomcat.Worker;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class WorkerTable
extends CachedTableIntegerKey<Worker> {
    private static final Logger logger = Logger.getLogger(WorkerTable.class.getName());
    private static final AoservTable.OrderBy[] defaultOrderBy = new AoservTable.OrderBy[]{new AoservTable.OrderBy("bind.server.package.name", true), new AoservTable.OrderBy("bind.server.name", true), new AoservTable.OrderBy("name", true)};

    WorkerTable(AoservConnector connector) {
        super(connector, Worker.class);
    }

    @Override
    protected AoservTable.OrderBy[] getDefaultOrderBy() {
        return defaultOrderBy;
    }

    @Override
    public Worker get(int bind) throws IOException, SQLException {
        return (Worker)this.getUniqueRow(0, bind);
    }

    public List<Worker> getHttpdWorkers(HttpdServer server) throws IOException, SQLException {
        int serverPkey = server.getPkey();
        List cached = this.getRows();
        int size = cached.size();
        ArrayList<Worker> matches = new ArrayList<Worker>(size);
        block0: for (int c = 0; c < size; ++c) {
            Worker worker = (Worker)cached.get(c);
            Site hts = worker.getTomcatSite();
            if (hts != null) {
                List<VirtualHost> binds = hts.getHttpdSite().getHttpdSiteBinds();
                for (VirtualHost bind : binds) {
                    if (bind.getHttpdBind().getHttpdServer_pkey() != serverPkey) continue;
                    matches.add(worker);
                    continue block0;
                }
                continue;
            }
            SharedTomcat hst = worker.getHttpdSharedTomcat();
            if (hst != null) {
                for (SharedTomcatSite htss : hst.getHttpdTomcatSharedSites()) {
                    List<VirtualHost> binds = htss.getHttpdTomcatSite().getHttpdSite().getHttpdSiteBinds();
                    for (VirtualHost bind : binds) {
                        if (bind.getHttpdBind().getHttpdServer_pkey() != serverPkey) continue;
                        matches.add(worker);
                        continue block0;
                    }
                }
                continue;
            }
            logger.log(Level.WARNING, "pkey=" + worker.getPkey(), new SQLException("HttpdWorker doesn't have either HttpdTomcatSite or HttpdSharedTomcat"));
        }
        return matches;
    }

    List<Worker> getHttpdWorkers(Site tomcatSite) throws IOException, SQLException {
        return this.getIndexedRows(2, tomcatSite.getPkey());
    }

    public Worker getHttpdWorker(Bind nb) throws IOException, SQLException {
        return (Worker)this.getUniqueRow(0, nb.getId());
    }

    @Override
    public Table.TableId getTableId() {
        return Table.TableId.HTTPD_WORKERS;
    }
}

