/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.security.plugin.tasks;

import com.appsflyer.security.plugin.tasks.impl.Downloader;
import com.appsflyer.security.plugin.utils.ExtKt;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010 \u001a\u00020!H\u0007J\b\u0010\"\u001a\u00020\u0005H\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u00020\u00138\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u00198G\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001bR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0007\u00a8\u0006#"}, d2={"Lcom/appsflyer/security/plugin/tasks/DownloadAppsFlyerSecuritySDK;", "Lorg/gradle/api/DefaultTask;", "()V", "aarFileName", "Lorg/gradle/api/provider/Property;", "", "getAarFileName", "()Lorg/gradle/api/provider/Property;", "applicationId", "getApplicationId", "authToken", "getAuthToken", "baseAarPath", "getBaseAarPath", "certificateHashes", "Lorg/gradle/api/provider/ListProperty;", "getCertificateHashes", "()Lorg/gradle/api/provider/ListProperty;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "setCoroutineScope", "(Lkotlinx/coroutines/CoroutineScope;)V", "libDir", "Ljava/io/File;", "getLibDir", "()Ljava/io/File;", "outputFile", "getOutputFile", "versionName", "getVersionName", "download", "", "getAppsFlyerSdkVersion", "af-security-plugin"})
public abstract class DownloadAppsFlyerSecuritySDK
extends DefaultTask {
    @Internal
    public CoroutineScope coroutineScope;

    @Input
    @NotNull
    public abstract Property<String> getAuthToken();

    @Input
    @NotNull
    public abstract Property<String> getBaseAarPath();

    @Input
    @NotNull
    public abstract Property<String> getAarFileName();

    @Input
    @NotNull
    public abstract Property<String> getApplicationId();

    @Input
    @NotNull
    public abstract Property<String> getVersionName();

    @Input
    @NotNull
    public abstract ListProperty<String> getCertificateHashes();

    @NotNull
    public final CoroutineScope getCoroutineScope() {
        CoroutineScope coroutineScope = this.coroutineScope;
        if (coroutineScope != null) {
            return coroutineScope;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"coroutineScope");
        return null;
    }

    public final void setCoroutineScope(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"<set-?>");
        this.coroutineScope = coroutineScope;
    }

    private final File getLibDir() {
        File file;
        File $this$_get_libDir__u24lambda_u240 = file = new File(this.getProject().getProjectDir(), (String)this.getBaseAarPath().get());
        boolean bl = false;
        if (!$this$_get_libDir__u24lambda_u240.exists()) {
            $this$_get_libDir__u24lambda_u240.mkdirs();
        }
        return file;
    }

    @OutputFile
    @NotNull
    public final File getOutputFile() {
        return new File(this.getLibDir(), (String)this.getAarFileName().get());
    }

    @TaskAction
    public final void download() {
        if (this.getOutputFile().exists()) {
            this.getLogger().lifecycle("AppsFlyer Security SDK for this version already presented in the build directory");
            return;
        }
        List list = (List)this.getCertificateHashes().getOrNull();
        if (list == null) {
            throw new GradleException("Missing Certificate Hashes, Please make sure to set this values in the plugin configuration block");
        }
        List certificates = list;
        Object object = this.getAuthToken().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"authToken.get()");
        String string = (String)object;
        Logger logger = this.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        Object object2 = this.getApplicationId().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"applicationId.get()");
        String string2 = (String)object2;
        Object object3 = this.getVersionName().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"versionName.get()");
        ExtKt.moveTo(new Downloader(string, certificates, logger, string2, (String)object3, this.getAppsFlyerSdkVersion(), this.getCoroutineScope()).downloadSecuritySdk(), this.getOutputFile(), true);
    }

    private final String getAppsFlyerSdkVersion() {
        Ref.ObjectRef version = new Ref.ObjectRef();
        this.getProject().getConfigurations().all(arg_0 -> DownloadAppsFlyerSecuritySDK.getAppsFlyerSdkVersion$lambda$1((Function1)new Function1<Configuration, Unit>((Ref.ObjectRef<String>)version, this){
            final /* synthetic */ Ref.ObjectRef<String> $version;
            final /* synthetic */ DownloadAppsFlyerSecuritySDK this$0;
            {
                this.$version = $version;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(Configuration it) {
                Object v3;
                block2: {
                    void $this$firstOrNull$iv;
                    DependencySet dependencySet = it.getAllDependencies();
                    Intrinsics.checkNotNullExpressionValue((Object)dependencySet, (String)"it.allDependencies");
                    Iterable iterable = (Iterable)dependencySet;
                    DownloadAppsFlyerSecuritySDK downloadAppsFlyerSecuritySDK = this.this$0;
                    boolean $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        Dependency dependency = (Dependency)element$iv;
                        boolean bl = false;
                        Logger logger = downloadAppsFlyerSecuritySDK.getLogger();
                        Object[] objectArray = "checking dependency: %s";
                        Object[] objectArray2 = new Object[]{dependency.toString()};
                        String string = String.format((String)objectArray, Arrays.copyOf(objectArray2, objectArray2.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(this, *args)");
                        logger.debug(string);
                        if (!(Intrinsics.areEqual((Object)dependency.getGroup(), (Object)"com.appsflyer") && CollectionsKt.listOf((Object[])(objectArray = new String[]{"af-android-sdk-beta", "af-android-sdk"})).contains(dependency.getName()))) continue;
                        v3 = element$iv;
                        break block2;
                    }
                    v3 = null;
                }
                Object object = v3;
                String tmpVersion = object != null ? object.getVersion() : null;
                object = tmpVersion;
                if (!(object == null || StringsKt.isBlank((CharSequence)object))) {
                    this.$version.element = tmpVersion;
                }
            }
        }, arg_0));
        Logger logger = this.getLogger();
        String string = "found version: %s";
        Object[] objectArray = new Object[]{version.element};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
        logger.debug(string2);
        String string3 = (String)version.element;
        if (string3 == null) {
            string3 = "";
        }
        return string3;
    }

    private static final void getAppsFlyerSdkVersion$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

