/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.security.plugin.tasks.impl;

import com.appsflyer.security.plugin.network.NetworkRepository;
import com.appsflyer.security.plugin.network.models.requests.GenerateAarBody;
import com.appsflyer.security.plugin.network.models.responses.CurrentBuildResponse;
import com.appsflyer.security.plugin.network.models.responses.DownloadAarResponse;
import com.appsflyer.security.plugin.network.models.responses.GenerateAarResponse;
import com.appsflyer.security.plugin.network.models.responses.Status;
import java.io.Closeable;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ?\u0010\u000e\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2'\u0010\u0010\u001a#\b\u0001\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000f0\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0011\u00a2\u0006\u0002\b\u0013H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0006\u0010\u001b\u001a\u00020\u001aJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\f\u0010\u001f\u001a\u00020\u001d*\u00020\u0003H\u0002R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006 "}, d2={"Lcom/appsflyer/security/plugin/tasks/impl/Downloader;", "", "authToken", "", "certificateHashes", "", "logger", "Lorg/gradle/api/logging/Logger;", "appId", "vName", "sdkVersion", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Ljava/lang/String;Ljava/util/List;Lorg/gradle/api/logging/Logger;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlinx/coroutines/CoroutineScope;)V", "blocking", "T", "block", "Lkotlin/Function2;", "Lkotlin/coroutines/Continuation;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "downloadAar", "", "networkRepository", "Lcom/appsflyer/security/plugin/network/NetworkRepository;", "outputFile", "Ljava/io/File;", "downloadSecuritySdk", "generateAar", "", "getBuildStatus", "logAndThrow", "af-security-plugin"})
public final class Downloader {
    @NotNull
    private final String authToken;
    @NotNull
    private final List<String> certificateHashes;
    @NotNull
    private final Logger logger;
    @NotNull
    private final String appId;
    @NotNull
    private final String vName;
    @NotNull
    private final String sdkVersion;
    @NotNull
    private final CoroutineScope coroutineScope;

    public Downloader(@NotNull String authToken, @NotNull List<String> certificateHashes, @NotNull Logger logger, @NotNull String appId, @NotNull String vName, @NotNull String sdkVersion, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)authToken, (String)"authToken");
        Intrinsics.checkNotNullParameter(certificateHashes, (String)"certificateHashes");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter((Object)vName, (String)"vName");
        Intrinsics.checkNotNullParameter((Object)sdkVersion, (String)"sdkVersion");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.authToken = authToken;
        this.certificateHashes = certificateHashes;
        this.logger = logger;
        this.appId = appId;
        this.vName = vName;
        this.sdkVersion = sdkVersion;
        this.coroutineScope = coroutineScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final File downloadSecuritySdk() {
        File tempFile = File.createTempFile("tempSecuritySDK", ".aar");
        Closeable closeable = new NetworkRepository(this.authToken, this.logger);
        Throwable throwable = null;
        try {
            NetworkRepository networkRepository = (NetworkRepository)closeable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)tempFile, (String)"tempFile");
            if (!this.downloadAar(networkRepository, tempFile)) {
                this.generateAar(networkRepository);
                this.getBuildStatus(networkRepository);
                if (!this.downloadAar(networkRepository, tempFile)) {
                    this.logAndThrow("Failed to generate and download Resources.");
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return tempFile;
    }

    private final void generateAar(NetworkRepository networkRepository) {
        GenerateAarBody genBody = new GenerateAarBody(this.certificateHashes);
        this.blocking((Function2)new Function2<CoroutineScope, Continuation<? super GenerateAarResponse>, Object>(networkRepository, this, genBody, null){
            int label;
            final /* synthetic */ NetworkRepository $networkRepository;
            final /* synthetic */ Downloader this$0;
            final /* synthetic */ GenerateAarBody $genBody;
            {
                this.$networkRepository = $networkRepository;
                this.this$0 = $receiver;
                this.$genBody = $genBody;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.$networkRepository.generateAar(Downloader.access$getAppId$p(this.this$0), Downloader.access$getVName$p(this.this$0), Downloader.access$getSdkVersion$p(this.this$0), this.$genBody, (Continuation<? super GenerateAarResponse>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super GenerateAarResponse> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private final void getBuildStatus(NetworkRepository networkRepository) {
        CurrentBuildResponse statusResponse2 = (CurrentBuildResponse)this.blocking((Function2)new Function2<CoroutineScope, Continuation<? super CurrentBuildResponse>, Object>(networkRepository, this, null){
            int label;
            final /* synthetic */ NetworkRepository $networkRepository;
            final /* synthetic */ Downloader this$0;
            {
                this.$networkRepository = $networkRepository;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.$networkRepository.getStatusUntilNotInProgress(Downloader.access$getAppId$p(this.this$0), Downloader.access$getVName$p(this.this$0), Downloader.access$getSdkVersion$p(this.this$0), (Continuation<? super CurrentBuildResponse>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super CurrentBuildResponse> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
        if (statusResponse2.getStatus() != Status.DONE) {
            String string = "Failed to generate AppsFlyer Security SDK:\n\tstatus: %s\n\terror: %s";
            Object[] objectArray = new Object[]{statusResponse2.getStatus(), statusResponse2.getError()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
            this.logAndThrow(string2);
        }
    }

    private final boolean downloadAar(NetworkRepository networkRepository, File outputFile) {
        DownloadAarResponse downloadAarResponse2 = (DownloadAarResponse)this.blocking((Function2)new Function2<CoroutineScope, Continuation<? super DownloadAarResponse>, Object>(networkRepository, this, outputFile, null){
            int label;
            final /* synthetic */ NetworkRepository $networkRepository;
            final /* synthetic */ Downloader this$0;
            final /* synthetic */ File $outputFile;
            {
                this.$networkRepository = $networkRepository;
                this.this$0 = $receiver;
                this.$outputFile = $outputFile;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.$networkRepository.downloadAar(Downloader.access$getAppId$p(this.this$0), Downloader.access$getVName$p(this.this$0), Downloader.access$getSdkVersion$p(this.this$0), this.$outputFile, (Continuation<? super DownloadAarResponse>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super DownloadAarResponse> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
        return downloadAarResponse2.isFileExist();
    }

    private final <T> T blocking(Function2<? super CoroutineScope, ? super Continuation<? super T>, ? extends Object> block) {
        return (T)BuildersKt.runBlocking((CoroutineContext)this.coroutineScope.getCoroutineContext(), block);
    }

    private final void logAndThrow(String $this$logAndThrow) {
        this.logger.error($this$logAndThrow);
        throw new GradleException($this$logAndThrow);
    }

    public static final /* synthetic */ String access$getAppId$p(Downloader $this) {
        return $this.appId;
    }

    public static final /* synthetic */ String access$getVName$p(Downloader $this) {
        return $this.vName;
    }

    public static final /* synthetic */ String access$getSdkVersion$p(Downloader $this) {
        return $this.sdkVersion;
    }
}

