package com.appsflyer.security.plugin

import java.io.Serializable

/**
 * This open class "TimeoutConfiguration" is used to configure timeouts for HTTP communication.
 * Implementing Serializable allows this class to be easily saved and retrieved across different contexts.
 *
 * @property requestTimeoutMillis Defines the maximum amount of time in milliseconds to wait for a complete HTTP request-response cycle.
 * @property connectTimeoutMillis Defines the maximum amount of time in milliseconds to wait for establishing an HTTP connection.
 * @property socketTimeoutMillis Defines the maximum amount of time in milliseconds of inactivity between two data packets when exchanging data with a server.
 */
open class TimeoutConfiguration : Serializable {
    /**
     * a time period required to process an HTTP call: from sending a request to receiving a response.
     */
    var requestTimeoutMillis: Long? = null

    /**
     *  a time period in which a client should establish a connection with a server.
     */
    var connectTimeoutMillis: Long? = null

    /**
     *  a maximum time of inactivity between two data packets when exchanging data with a server.
     */
    var socketTimeoutMillis: Long? = null
}