package com.appsflyer.security.plugin.network.resources

import com.appsflyer.security.plugin.BuildConfig
import io.ktor.resources.Resource
import org.gradle.internal.impldep.com.google.gson.annotations.SerializedName


@Resource("/{clientAppId}")
class AppId(
    val clientAppId: String, @SerializedName("app_version") val app_version: String,
    @SerializedName("sdk_version") val sdk_version: String,
    @SerializedName("plugin_version") val plugin_version: String = BuildConfig.VERSION_NAME,
) {
    @Resource("/generate-aar")
    class GenerateAar(val parent: AppId) {
        constructor(appId: String, appVersion: String, sdkVersion: String) : this(
            AppId(
                appId,
                appVersion,
                sdkVersion
            )
        )
    }

    @Resource("/current-build-status")
    class CurrentBuildStatus(val parent: AppId) {
        constructor(appId: String, appVersion: String, sdkVersion: String) : this(
            AppId(
                appId,
                appVersion,
                sdkVersion
            )
        )
    }

    @Resource("/download-aar")
    class DownloadAar(val parent: AppId) {
        constructor(appId: String, appVersion: String, sdkVersion: String) : this(
            AppId(
                appId,
                appVersion,
                sdkVersion
            )
        )
    }
}
