package com.appsflyer.security.plugin.utils

internal const val APPSFLYER_HQ_BASE_ENDPOINT = "https://hq1.appsflyer.com/api/security-sdk/v1.0/app/"
internal const val APPSFLYER_PLUGIN_NAME = "appsFlyerSecurityPlugin"
internal const val APPLICATION_PLUGIN_NAME = "com.android.application"
internal const val MISSING_APPLICATION_PLUGIN_ERR = "'com.android.application' plugin is required"
internal const val MIN_GRADLE_VERSION = "7.0"
internal const val GRADLE_VERSION_ERR = "Android Gradle Plugin version 7.0 or newer is required"
internal const val WRONG_AUTH_TOKEN_FORMAT = "Wrong Auth Token format. Please verify the token specified in the plugin configuration block"
internal const val MISSING_AUTH_TOKEN = "Missing Auth Token, Please make sure to set this values in the plugin configuration block"
internal const val MISSING_CERTIFICATE_HASHES = "Missing Certificate Hashes. Please make sure to set this values in the plugin configuration block"
internal const val COULD_NOT_GENERATE_AAR_FILE = "Could not generate AAR file"
internal const val APPSFLYER_BETA_DEPENDENCY = "af-android-sdk-beta"
internal const val APPSFLYER_PROD_DEPENDENCY = "af-android-sdk"
internal const val APPSFLYER_GROUP = "com.appsflyer"
internal const val SDK_ALREADY_AVAILABLE_LOG = "AppsFlyer Security SDK for this version already presented in the build directory"
internal const val OK = "OK"
internal const val BUILDING_IN_PROGRESS_LOG = "[%d/%d] Building in progress, will check again in 10 sec\n\tCurrent Status: %s"
internal const val MAX_RETRIES_EXCEEDED_ERR = "Max retries exceeded"
internal const val FOUND_VERSION_LOG = "found version: %s"
internal const val CHECKING_DEPENDENCY_LOG = "checking dependency: %s"
internal const val FAILED_TO_GENERATE_ERR = "Failed to generate AppsFlyer Security SDK:\n\tmessage: %s\n\terror: %s"
internal const val GET_STATUS_ERR = "Failed to generate AppsFlyer Security SDK:\n\tstatus: %s\n\terror: %s"
internal const val FAILED_TO_DOWNLOAD_ERR = "Failed to download AppsFlyer Security SDK: %s"
internal const val BASE_AAR_PATH = "build/generated/appsflyer/aar/"

internal const val DOWNLOAD_TASK_PREFIX = "downloadAppsFlyerSecurity%s"
internal const val CONSUME_TASK_PREFIX  = "consumeAppsFlyerSecurity%s"
internal const val ASSEMBLE_TASK_PREFIX = "assemble%s"
internal const val BUNDLE_TASK_PREFIX = "bundle%s"
internal const val PRE_BUILD_TASK_PREFIX = "pre%sBuild"
internal const val PROCESS_MANIFEST_TASK_PREFIX = "process%sManifest"
internal const val COLLECT_DEPENDENCIES_TASK_PREFIX = "collect%sDependencies"
internal const val DATA_BINDING_TASK_PREFIX = "dataBindingMergeDependencyArtifacts%s"
internal const val IMPLEMENTATION_PREFIX = "%sImplementation"
internal const val AAR_BASE_NAME = "af-security-%s%s.aar"
internal const val TEMP_AAR_FILE_NAME = "tempSecuritySDK"
internal const val AAR_FILE_EXT = ".aar"
internal const val BODY_FAILED_DECODING: String = "<body failed decoding>"
internal const val JWE_TOKEN_REGEX: String = "^([A-Za-z0-9-_=]+\\.){4}[A-Za-z0-9-_=]*\$"

internal const val MAX_RETRIES = 60
internal const val DELAY_MILLIS = 10000L
