/*
 * Decompiled with CFR 0.152.
 */
package com.arboratum.beangen.core;

import com.arboratum.beangen.Generator;
import com.arboratum.beangen.util.RandomSequence;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

public abstract class AbstractGeneratorBuilder<CLASS> {
    protected final Class<CLASS> fieldType;
    private Function<RandomSequence, CLASS> generator;

    public AbstractGeneratorBuilder(Class<CLASS> fieldType) {
        this.fieldType = fieldType;
    }

    protected void setup(Function<RandomSequence, CLASS> generator) {
        this.generator = generator;
    }

    public Generator<CLASS> build() {
        this.assertFieldTypeSupported();
        return new DelegateGenerator<CLASS>(this.fieldType, this.generator);
    }

    protected void assertFieldTypeSupported() {
        try {
            Set supported_types = (Set)this.getClass().getField("SUPPORTED_TYPES").get(null);
            if (!supported_types.contains(this.fieldType)) {
                throw new IllegalArgumentException("Type not supported by this generator");
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Not SUPPORTED_TYPES static field accessible in class" + this.getClass());
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Not SUPPORTED_TYPES static field found in class" + this.getClass());
        }
    }

    public Class<CLASS> getFieldType() {
        return this.fieldType;
    }

    public Function<RandomSequence, CLASS> getGenerator() {
        return this.generator;
    }

    public void setGenerator(Function<RandomSequence, CLASS> generator) {
        this.generator = generator;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractGeneratorBuilder)) {
            return false;
        }
        AbstractGeneratorBuilder other = (AbstractGeneratorBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Class<CLASS> this$fieldType = this.getFieldType();
        Class<CLASS> other$fieldType = other.getFieldType();
        if (this$fieldType == null ? other$fieldType != null : !this$fieldType.equals(other$fieldType)) {
            return false;
        }
        Function<RandomSequence, CLASS> this$generator = this.getGenerator();
        Function<RandomSequence, CLASS> other$generator = other.getGenerator();
        return !(this$generator == null ? other$generator != null : !this$generator.equals(other$generator));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<CLASS> $fieldType = this.getFieldType();
        result = result * 59 + ($fieldType == null ? 43 : $fieldType.hashCode());
        Function<RandomSequence, CLASS> $generator = this.getGenerator();
        result = result * 59 + ($generator == null ? 43 : $generator.hashCode());
        return result;
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractGeneratorBuilder;
    }

    public String toString() {
        return "com.arboratum.beangen.core.AbstractGeneratorBuilder(fieldType=" + this.getFieldType() + ", generator=" + this.getGenerator() + ")";
    }

    public AbstractGeneratorBuilder<CLASS> postProcess(final BiFunction<CLASS, RandomSequence, CLASS> processor) {
        return new AbstractGeneratorBuilder(this.fieldType){

            public Generator build() {
                final Generator source = AbstractGeneratorBuilder.this.build();
                return new Generator(this.fieldType){

                    public Object generate(RandomSequence register) {
                        return processor.apply(source.generate(register), register);
                    }
                };
            }
        };
    }

    public <TARGET> AbstractGeneratorBuilder<TARGET> convert(Function<CLASS, TARGET> conversion) {
        Type type = conversion.getClass().getGenericSuperclass();
        Class targetType = type instanceof ParameterizedType ? (Class)((ParameterizedType)type).getActualTypeArguments()[1] : Object.class;
        return this.convert(conversion, targetType);
    }

    public <TARGET> AbstractGeneratorBuilder<TARGET> convert(final Function<CLASS, TARGET> conversion, final Class<TARGET> targetType) {
        final Generator<CLASS> source = this.build();
        return new AbstractGeneratorBuilder(targetType){

            public Generator build() {
                return new Generator(targetType){

                    public Object generate(RandomSequence register) {
                        return conversion.apply(source.generate(register));
                    }
                };
            }
        };
    }

    public AbstractGeneratorBuilder<String> convertToString() {
        final Generator<CLASS> source = this.build();
        return new AbstractGeneratorBuilder(Object.class){

            public Generator build() {
                return new Generator(String.class){

                    public String generate(RandomSequence register) {
                        return String.valueOf(source.generate(register));
                    }
                };
            }
        };
    }

    private static class DelegateGenerator<CLASS>
    extends Generator<CLASS> {
        private final Function<RandomSequence, CLASS> generator;

        protected DelegateGenerator(Class<CLASS> type, Function<RandomSequence, CLASS> generator) {
            super(type);
            this.generator = generator;
        }

        @Override
        public CLASS generate(RandomSequence register) {
            return this.generator.apply(register);
        }
    }
}

