/*
 * Decompiled with CFR 0.152.
 */
package com.arboratum.beangen.core;

import com.arboratum.beangen.BaseBuilders;
import com.arboratum.beangen.Generator;
import com.arboratum.beangen.core.AbstractGeneratorBuilder;
import com.arboratum.beangen.core.BooleanGeneratorBuilder;
import com.arboratum.beangen.core.CharSequenceGeneratorBuilder;
import com.arboratum.beangen.core.CombinedFieldValue;
import com.arboratum.beangen.core.DateGeneratorBuilder;
import com.arboratum.beangen.core.DecimalGeneratorBuilder;
import com.arboratum.beangen.core.EnumGeneratorBuilder;
import com.arboratum.beangen.core.IntegerGeneratorBuilder;
import com.arboratum.beangen.util.Populator;
import com.arboratum.beangen.util.RandomSequence;
import com.arboratum.beangen.util.ValueAssigner;
import com.esotericsoftware.reflectasm.ConstructorAccess;
import com.esotericsoftware.reflectasm.MethodAccess;
import com.google.common.primitives.Primitives;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuple3;
import reactor.util.function.Tuples;

public class BeanGeneratorBuilder<CLASS>
extends AbstractGeneratorBuilder<CLASS> {
    private final MethodAccess access;
    private final SortedMap<String, Generator> populators = new TreeMap<String, Generator>();
    private final LinkedHashMap<Object, Generator> populators2 = new LinkedHashMap();
    private String idfield;
    private List<Generator<CombinedFieldValue<CLASS>>> updateOfPopulators = new ArrayList<Generator<CombinedFieldValue<CLASS>>>();

    public BeanGeneratorBuilder(Class<CLASS> type) {
        super(type);
        this.access = MethodAccess.get(type);
    }

    @Override
    protected void assertFieldTypeSupported() {
    }

    @Override
    public Generator<CLASS> build() {
        ConstructorAccess constructorAccess = ConstructorAccess.get((Class)this.fieldType);
        ArrayList pops = new ArrayList();
        this.populators.entrySet().stream().map(e -> new Populator(this.getValueAssigner((String)e.getKey()), (Function)e.getValue())).collect(Collectors.toCollection(() -> pops));
        this.populators2.entrySet().stream().map(e -> {
            if (e.getKey() instanceof Tuple3) {
                Tuple3 k = (Tuple3)e.getKey();
                return new Populator(this.getValueAssigner((String)k.getT1(), (String)k.getT2(), (String)k.getT3()), (Function)e.getValue());
            }
            if (e.getKey() instanceof Tuple2) {
                Tuple2 k = (Tuple2)e.getKey();
                return new Populator(this.getValueAssigner((String)k.getT1(), (String)k.getT2()), (Function)e.getValue());
            }
            throw new RuntimeException("bug");
        }).collect(Collectors.toCollection(() -> pops));
        this.updateOfPopulators.stream().map(updateGenerator -> new Populator(new ValueAssigner<CLASS, CombinedFieldValue<CLASS>>(){

            @Override
            public void assign(CLASS object, CombinedFieldValue<CLASS> updateOf) {
                updateOf.apply(object);
            }

            @Override
            public boolean accept(Class<? extends CombinedFieldValue<CLASS>> type) {
                return true;
            }
        }, updateGenerator)).collect(Collectors.toCollection(() -> pops));
        this.setup(seq -> {
            Object o = constructorAccess.newInstance();
            for (Populator p : pops) {
                p.populate(o, (RandomSequence)seq);
            }
            return o;
        });
        return super.build();
    }

    public BeanGeneratorBuilder<CLASS> withDefaultFieldPopulators() {
        String[] methodNames = this.access.getMethodNames();
        TreeSet<IndexedMethod> methods = new TreeSet<IndexedMethod>();
        for (int i = 0; i < methodNames.length; ++i) {
            methods.add(new IndexedMethod(i, methodNames[i]));
        }
        Class[] returnTypes = this.access.getReturnTypes();
        Class[][] parameterTypes = this.access.getParameterTypes();
        for (IndexedMethod method : methods) {
            String fieldName;
            int i = method.i;
            if (returnTypes[i] != Void.TYPE || parameterTypes[i].length != 1 || !methodNames[i].startsWith("set") || this.populators.containsKey(fieldName = methodNames[i].substring(3, 4).toLowerCase() + methodNames[i].substring(4))) continue;
            int methodIndex = i;
            Class aClass = parameterTypes[i][0];
            if (BooleanGeneratorBuilder.SUPPORTED_TYPES.contains((Object)aClass)) {
                this.with(fieldName, BaseBuilders.aBoolean().uniform());
                continue;
            }
            if (IntegerGeneratorBuilder.SUPPORTED_TYPES.contains((Object)aClass)) {
                this.with(fieldName, new IntegerGeneratorBuilder(aClass).uniform());
                continue;
            }
            if (DecimalGeneratorBuilder.SUPPORTED_TYPES.contains((Object)aClass)) {
                this.with(fieldName, new DecimalGeneratorBuilder(aClass).uniform());
                continue;
            }
            if (CharSequenceGeneratorBuilder.SUPPORTED_TYPES.contains((Object)aClass)) {
                this.with(fieldName, new CharSequenceGeneratorBuilder(aClass).alphaNumeric(0, 20));
                continue;
            }
            if (DateGeneratorBuilder.SUPPORTED_TYPES.contains((Object)aClass)) {
                this.with(fieldName, new DateGeneratorBuilder(aClass).uniform());
                continue;
            }
            if (aClass.isEnum()) {
                this.with(fieldName, new EnumGeneratorBuilder(aClass).uniform());
                continue;
            }
            if (Modifier.isAbstract(aClass.getModifiers())) continue;
            this.with(fieldName, new BeanGeneratorBuilder<CLASS>(aClass).withDefaultFieldPopulators());
        }
        return this;
    }

    public BeanGeneratorBuilder<CLASS> injectIdIn(String fieldName) {
        this.populators.put(fieldName, new Generator(Long.class){

            public Object generate(RandomSequence register) {
                return register.getSeed();
            }
        });
        return this;
    }

    public BeanGeneratorBuilder<CLASS> with(AbstractGeneratorBuilder<CombinedFieldValue<CLASS>> generator) {
        return this.with(generator.build());
    }

    public <VALUE> BeanGeneratorBuilder<CLASS> with(String fieldName, AbstractGeneratorBuilder<VALUE> generator) {
        return this.with(fieldName, generator.build());
    }

    public BeanGeneratorBuilder<CLASS> with(Generator<CombinedFieldValue<CLASS>> generator) {
        this.updateOfPopulators.add(generator);
        return this;
    }

    public <VALUE> BeanGeneratorBuilder<CLASS> with(String fieldName, Generator<VALUE> generator) {
        ValueAssigner valueAssigner = this.getValueAssigner(fieldName);
        if (!valueAssigner.accept(generator.getType())) {
            throw new IllegalArgumentException("The field '" + fieldName + "' cannot be set to type accept with type " + generator.getType());
        }
        this.populators.put(fieldName, generator);
        return this;
    }

    public <FIELD1, FIELD2> BeanGeneratorBuilder<CLASS> with(String fieldName1, String fieldName2, AbstractGeneratorBuilder<Tuple2<FIELD1, FIELD2>> generator) {
        return this.with(fieldName1, fieldName2, generator.build());
    }

    public <FIELD1, FIELD2, FIELD3> BeanGeneratorBuilder<CLASS> with(String fieldName1, String fieldName2, String fieldName3, AbstractGeneratorBuilder<Tuple3<FIELD1, FIELD2, FIELD3>> generator) {
        return this.with(fieldName1, fieldName2, fieldName3, generator.build());
    }

    public <FIELD1, FIELD2> BeanGeneratorBuilder<CLASS> with(String fieldName1, String fieldName2, Generator<Tuple2<FIELD1, FIELD2>> generator) {
        ValueAssigner<CLASS, Tuple2<FIELD1, FIELD2>> valueAssigner = this.getValueAssigner(fieldName1, fieldName2);
        if (!valueAssigner.accept(generator.getType())) {
            throw new IllegalArgumentException("The field '" + fieldName1 + "," + fieldName2 + "' cannot be set to type accept with type " + generator.getType());
        }
        this.populators2.put(Tuples.of((Object)fieldName1, (Object)fieldName2), generator);
        return this;
    }

    public <FIELD1, FIELD2, FIELD3> BeanGeneratorBuilder<CLASS> with(String fieldName1, String fieldName2, String fieldName3, Generator<Tuple3<FIELD1, FIELD2, FIELD3>> generator) {
        ValueAssigner<CLASS, Tuple3<FIELD1, FIELD2, FIELD3>> valueAssigner = this.getValueAssigner(fieldName1, fieldName2, fieldName3);
        if (!valueAssigner.accept(generator.getType())) {
            throw new IllegalArgumentException("The field '" + fieldName1 + "," + fieldName2 + "' cannot be set to type accept with type " + generator.getType());
        }
        this.populators2.put(Tuples.of((Object)fieldName1, (Object)fieldName2, (Object)fieldName3), generator);
        return this;
    }

    private <CLASS, FIELD1, FIELD2> ValueAssigner<CLASS, Tuple2<FIELD1, FIELD2>> getValueAssigner(String fieldName1, String fieldName2) {
        final ValueAssigner valueAssigner1 = this.getValueAssigner(fieldName1);
        final ValueAssigner valueAssigner2 = this.getValueAssigner(fieldName2);
        return new ValueAssigner<CLASS, Tuple2<FIELD1, FIELD2>>(){

            @Override
            public void assign(CLASS object, Tuple2<FIELD1, FIELD2> values) {
                valueAssigner1.assign(object, values.getT1());
                valueAssigner2.assign(object, values.getT2());
            }

            @Override
            public boolean accept(Class<? extends Tuple2<FIELD1, FIELD2>> type) {
                ParameterizedType typeInfo = (ParameterizedType)type.getGenericSuperclass();
                if (typeInfo == null) {
                    return true;
                }
                Class type1 = (Class)typeInfo.getActualTypeArguments()[0];
                Class type2 = (Class)typeInfo.getActualTypeArguments()[1];
                return valueAssigner1.accept(type1) && valueAssigner2.accept(type2);
            }
        };
    }

    private <CLASS, FIELD1, FIELD2, FIELD3> ValueAssigner<CLASS, Tuple3<FIELD1, FIELD2, FIELD3>> getValueAssigner(String fieldName1, String fieldName2, String fieldName3) {
        final ValueAssigner valueAssigner1 = this.getValueAssigner(fieldName1);
        final ValueAssigner valueAssigner2 = this.getValueAssigner(fieldName2);
        final ValueAssigner valueAssigner3 = this.getValueAssigner(fieldName3);
        return new ValueAssigner<CLASS, Tuple3<FIELD1, FIELD2, FIELD3>>(){

            @Override
            public void assign(CLASS object, Tuple3<FIELD1, FIELD2, FIELD3> values) {
                valueAssigner1.assign(object, values.getT1());
                valueAssigner2.assign(object, values.getT2());
                valueAssigner3.assign(object, values.getT3());
            }

            @Override
            public boolean accept(Class<? extends Tuple3<FIELD1, FIELD2, FIELD3>> type) {
                ParameterizedType typeInfo = (ParameterizedType)type.getGenericSuperclass();
                if (typeInfo == null) {
                    return true;
                }
                Class type1 = (Class)typeInfo.getActualTypeArguments()[0];
                Class type2 = (Class)typeInfo.getActualTypeArguments()[1];
                Class type3 = (Class)typeInfo.getActualTypeArguments()[2];
                return valueAssigner1.accept(type1) && valueAssigner2.accept(type2) && valueAssigner3.accept(type3);
            }
        };
    }

    private <CLASS, FIELD> ValueAssigner<CLASS, FIELD> getValueAssigner(String fieldName) {
        final int methodIndex = this.access.getIndex("set" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1), 1);
        return new ValueAssigner<CLASS, FIELD>(){

            @Override
            public void assign(CLASS o, FIELD v) {
                BeanGeneratorBuilder.this.access.invoke(o, methodIndex, new Object[]{v});
            }

            @Override
            public boolean accept(Class<? extends FIELD> type) {
                Class parameterClass = BeanGeneratorBuilder.this.access.getParameterTypes()[methodIndex][0];
                if (parameterClass.isAssignableFrom(type)) {
                    return true;
                }
                if (parameterClass.isPrimitive() && parameterClass == Primitives.unwrap(type)) {
                    return true;
                }
                return type.isPrimitive() && type == Primitives.unwrap((Class)parameterClass);
            }
        };
    }

    private Class getFieldType(String fieldName) {
        int methodIndex = this.access.getIndex("set" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1));
        return this.access.getParameterTypes()[methodIndex][0];
    }

    private static class IndexedMethod
    implements Comparable<IndexedMethod> {
        final int i;
        final String methodName;

        private IndexedMethod(int i, String methodName) {
            this.i = i;
            this.methodName = methodName;
        }

        @Override
        public int compareTo(IndexedMethod o) {
            return this.methodName.compareTo(o.methodName);
        }
    }
}

