/*
 * Decompiled with CFR 0.152.
 */
package com.arboratum.beangen.core;

import com.arboratum.beangen.BaseBuilders;
import com.arboratum.beangen.Generator;
import com.arboratum.beangen.core.AbstractGeneratorBuilder;
import com.arboratum.beangen.distribution.RegExpStringGenerator;
import com.arboratum.beangen.util.IntSequence;
import com.arboratum.beangen.util.MathUtils;
import com.arboratum.beangen.util.RandomSequence;
import com.arboratum.beangen.util.ToCharFunction;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Chars;
import java.nio.CharBuffer;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import org.apache.commons.math3.stat.Frequency;

public class CharSequenceGeneratorBuilder<VALUE>
extends AbstractGeneratorBuilder<VALUE> {
    public static final ImmutableSet<Class> SUPPORTED_TYPES = ImmutableSet.of(String.class, CharBuffer.class, Appendable.class, CharSequence.class, StringBuffer.class, StringBuilder.class, (Object[])new Class[]{new char[0].getClass()});
    private static Cache<ImmutableList<String>, MathUtils.SubSetSumIndex> sumIndexCache = CacheBuilder.newBuilder().maximumSize(100L).build();

    public CharSequenceGeneratorBuilder(Class<VALUE> fieldType) {
        super(fieldType);
    }

    private void buildFromCharArrayGenerator(Function<RandomSequence, char[]> valueFunction) {
        if (this.fieldType == String.class) {
            this.setup(r -> new String((char[])valueFunction.apply((RandomSequence)r)));
        } else if (this.fieldType == CharBuffer.class || this.fieldType == Appendable.class || this.fieldType == CharSequence.class) {
            this.setup(r -> CharBuffer.wrap((char[])valueFunction.apply((RandomSequence)r)));
        } else if (this.fieldType == StringBuilder.class) {
            this.setup(r -> {
                char[] value = (char[])valueFunction.apply((RandomSequence)r);
                StringBuilder sb = new StringBuilder(value.length);
                sb.append(value);
                return sb;
            });
        } else if (this.fieldType == StringBuffer.class) {
            this.setup(r -> {
                char[] value = (char[])valueFunction.apply((RandomSequence)r);
                StringBuffer sb = new StringBuffer(value.length);
                sb.append(value);
                return sb;
            });
        } else if (this.fieldType.isArray() && this.fieldType.getComponentType() == Character.TYPE) {
            this.setup(valueFunction);
        } else {
            throw new IllegalArgumentException("Unsupported type");
        }
    }

    public CharSequenceGeneratorBuilder<VALUE> withCharacters(String chars) {
        new CharSetGeneratorConfig(chars).uniformLength(0, 20);
        return this;
    }

    public CharSetGeneratorConfig withCharactersAnd(String chars) {
        return new CharSetGeneratorConfig(chars);
    }

    public CharSetGeneratorConfig withCharactersAnd(Frequency charsAndFrequency) {
        return new CharSetGeneratorConfig(charsAndFrequency);
    }

    public CharSequenceGeneratorBuilder<VALUE> withWords(ImmutableList<String> words, int length, int numberUnique, long valueSetGeneratorSeed) {
        MathUtils.SubSetSumIndex subSetSumIndex;
        try {
            subSetSumIndex = (MathUtils.SubSetSumIndex)sumIndexCache.get(words, () -> {
                int[] lengths = words.stream().mapToInt(String::length).map(l -> l + 1).toArray();
                return new MathUtils.SubSetSumIndex(lengths);
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException("bug", e);
        }
        subSetSumIndex.rebuild(length + 1);
        Generator<IntSequence> generator = MathUtils.randomSubSetSum(length + 1, numberUnique, new RandomSequence(valueSetGeneratorSeed), subSetSumIndex);
        this.buildFromCharArrayGenerator(randomSequence -> {
            int i;
            IntSequence s = (IntSequence)generator.generate((RandomSequence)randomSequence);
            if (s == null) {
                return new char[0];
            }
            char[] builder = new char[length];
            int pos = 0;
            int endi = s.length() - 1;
            for (i = 0; i < endi; ++i) {
                String word = (String)words.get(s.intAt(i));
                int wordLength = word.length();
                word.getChars(0, wordLength, builder, pos);
                builder[pos += wordLength] = 32;
                ++pos;
            }
            String word = (String)words.get(s.intAt(i));
            int wordLength = word.length();
            word.getChars(0, wordLength, builder, pos);
            return builder;
        });
        return this;
    }

    public CharSequenceGeneratorBuilder<VALUE> matching(String regexp) {
        RegExpStringGenerator valueFunction = new RegExpStringGenerator(regexp);
        this.buildFromCharArrayGenerator(valueFunction);
        return this;
    }

    public CharSequenceGeneratorBuilder<VALUE> alphaNumeric(int minSize, int maxSize) {
        return this.withCharactersAnd("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0987654321").uniformLength(minSize, maxSize);
    }

    public class CharSetGeneratorConfig {
        private final ToCharFunction<RandomSequence> nextChar;

        CharSetGeneratorConfig(String characters) {
            char[] chars = Chars.toArray(new TreeSet(Chars.asList((char[])characters.toCharArray())));
            this.nextChar = r -> chars[r.nextInt(chars.length)];
        }

        public CharSetGeneratorConfig(Frequency frequency) {
            Generator<Character> charGenerator = BaseBuilders.enumerated(Character.class).from(frequency).build();
            this.nextChar = r -> ((Character)charGenerator.apply((RandomSequence)r)).charValue();
        }

        public CharSequenceGeneratorBuilder<VALUE> uniformLength(int min, int max) {
            int range = max - min + 1;
            ToIntFunction<RandomSequence> lengthGenerator = r -> r.nextInt(range) + min;
            this.buildGenerator(lengthGenerator);
            return CharSequenceGeneratorBuilder.this;
        }

        public CharSequenceGeneratorBuilder<VALUE> lengthDistribution(Frequency frequency) {
            Generator<Number> charGenerator = BaseBuilders.enumerated(Number.class).from(frequency).build();
            ToIntFunction<RandomSequence> lengthGenerator = r -> ((Number)charGenerator.apply((RandomSequence)r)).intValue();
            this.buildGenerator(lengthGenerator);
            return CharSequenceGeneratorBuilder.this;
        }

        private void buildGenerator(ToIntFunction<RandomSequence> lengthGenerator) {
            Function<RandomSequence, char[]> valueFunction = r -> {
                int size = lengthGenerator.applyAsInt((RandomSequence)r);
                char[] buffer = new char[size];
                for (int i = 0; i < size; ++i) {
                    buffer[i] = this.nextChar.applyAsChar((RandomSequence)r);
                }
                return buffer;
            };
            CharSequenceGeneratorBuilder.this.buildFromCharArrayGenerator(valueFunction);
        }
    }
}

