/*
 * Decompiled with CFR 0.152.
 */
package com.arboratum.beangen.core;

import com.arboratum.beangen.BaseBuilders;
import com.arboratum.beangen.Generator;
import com.arboratum.beangen.core.AbstractGeneratorBuilder;
import com.arboratum.beangen.util.RandomSequence;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.math3.stat.Frequency;

public class CollectionGeneratorBuilder<VALUE, COL extends Collection<VALUE>>
extends AbstractGeneratorBuilder<COL> {
    private static final Logger log = Logger.getLogger(CollectionGeneratorBuilder.class.getName());
    public static final ImmutableSet<Class> SUPPORTED_TYPES = ImmutableSet.of(List.class, Set.class);

    public CollectionGeneratorBuilder(Class<COL> fieldType) {
        super(fieldType);
    }

    public CollectionGeneratorBuilder<VALUE, COL> of(int min, int max, AbstractGeneratorBuilder<VALUE> valueGenerator) {
        return this.of(min, max, valueGenerator.build());
    }

    public CollectionGeneratorBuilder<VALUE, COL> of(int min, int max, Generator<VALUE> valueGenerator) {
        return this.of(BaseBuilders.aInteger().uniform(min, max).build(), valueGenerator);
    }

    public CollectionGeneratorBuilder<VALUE, COL> of(Frequency sizeFrequency, AbstractGeneratorBuilder<VALUE> valueGenerator) {
        return this.of(BaseBuilders.enumerated(Integer.class).from(sizeFrequency).build(), valueGenerator.build());
    }

    public CollectionGeneratorBuilder<VALUE, COL> of(Frequency sizeFrequency, Generator<VALUE> valueGenerator) {
        return this.of(BaseBuilders.enumerated(Integer.class).from(sizeFrequency).build(), valueGenerator);
    }

    public CollectionGeneratorBuilder<VALUE, COL> of(Generator<? extends Number> sizeGenerator, Generator<VALUE> valueGenerator) {
        if (this.fieldType.isAssignableFrom(LinkedHashSet.class)) {
            this.setup(randomSequence -> {
                int size = ((Number)sizeGenerator.apply((RandomSequence)randomSequence)).intValue();
                LinkedHashSet r = new LinkedHashSet(size);
                int i = 0;
                while (r.size() < size) {
                    r.add(valueGenerator.generate((RandomSequence)randomSequence));
                    if (i > 10 * size) {
                        log.warning("Seems we cannot generate a value for the set that doesn't exist yet. Stop trying.");
                        break;
                    }
                    ++i;
                }
                return r;
            });
        } else if (this.fieldType.isAssignableFrom(ArrayList.class)) {
            this.setup(randomSequence -> {
                int size = ((Number)sizeGenerator.apply((RandomSequence)randomSequence)).intValue();
                ArrayList r = new ArrayList(size);
                for (int i = 0; i < size; ++i) {
                    r.add(valueGenerator.generate((RandomSequence)randomSequence));
                }
                return r;
            });
        }
        return this;
    }
}

