/*
 * Decompiled with CFR 0.152.
 */
package com.arboratum.beangen.core;

import com.arboratum.beangen.core.AbstractGeneratorBuilder;
import com.arboratum.beangen.distribution.UniformIntegerDistribution;
import com.arboratum.beangen.util.RandomSequence;
import com.google.common.collect.ImmutableSet;
import java.util.Calendar;
import java.util.Date;
import java.util.function.Function;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;

public class DateGeneratorBuilder<VALUE>
extends AbstractGeneratorBuilder<VALUE> {
    public static final ImmutableSet<Class> SUPPORTED_TYPES = ImmutableSet.of(Date.class, Calendar.class);
    private DateTimeZone zone = DateTimeZone.UTC;

    public DateGeneratorBuilder(Class<VALUE> fieldType) {
        super(fieldType);
    }

    public DateGeneratorBuilder<VALUE> uniform() {
        this.setupFromLong(RandomSequence::nextLong);
        return this;
    }

    public DateGeneratorBuilder<VALUE> uniform(Date min, Date max) {
        Function<RandomSequence, Long> function = new UniformIntegerDistribution<Long>(min.getTime(), max.getTime(), Long.TYPE).build();
        this.setupFromLong(function);
        return this;
    }

    private void setupFromLong(Function<RandomSequence, Long> function) {
        if (this.fieldType.isAssignableFrom(Date.class)) {
            this.setup(randomSequence -> new Instant(function.apply((RandomSequence)randomSequence)).toDateTime(this.zone).withMillisOfDay(0).toDate());
        } else {
            this.setup(randomSequence -> new Instant(function.apply((RandomSequence)randomSequence)).toDateTime(this.zone).withMillisOfDay(0).toGregorianCalendar());
        }
    }
}

