/*
 * Decompiled with CFR 0.152.
 */
package com.arboratum.beangen.core;

import com.arboratum.beangen.core.AbstractGeneratorBuilder;
import com.arboratum.beangen.distribution.CommonsMathDecimalDistribution;
import com.arboratum.beangen.distribution.UniformDecimalDistribution;
import com.google.common.collect.ImmutableSet;
import org.apache.commons.math3.distribution.RealDistribution;

public class DecimalGeneratorBuilder<VALUE extends Number>
extends AbstractGeneratorBuilder<VALUE> {
    public static final ImmutableSet<Class> SUPPORTED_TYPES = ImmutableSet.of(Float.TYPE, Float.class, Double.TYPE, Double.class);

    public DecimalGeneratorBuilder(Class<VALUE> fieldType) {
        super(fieldType);
    }

    public DecimalGeneratorBuilder<VALUE> uniform() {
        this.setup(new UniformDecimalDistribution<Object>(null, null, this.fieldType).build());
        return this;
    }

    public DecimalGeneratorBuilder<VALUE> uniform(VALUE min, VALUE max) {
        this.setup(new UniformDecimalDistribution<VALUE>(min, max, this.fieldType).build());
        return this;
    }

    public DecimalGeneratorBuilder<VALUE> distribution(RealDistribution distribution) {
        this.setup(new CommonsMathDecimalDistribution(distribution, null, this.fieldType).build());
        return this;
    }
}

