/*
 * Decompiled with CFR 0.152.
 */
package com.arboratum.beangen.core;

import com.arboratum.beangen.Generator;
import com.arboratum.beangen.core.AbstractGeneratorBuilder;
import com.arboratum.beangen.util.DistributionUtils;
import com.arboratum.beangen.util.RandomSequence;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.math3.stat.Frequency;
import org.apache.commons.math3.util.MathArrays;

public class EnumeratedDistributionGeneratorBuilder<CLASS>
extends AbstractGeneratorBuilder<CLASS> {
    private double[] weights;
    private CLASS[] values;
    private AbstractGeneratorBuilder<? extends CLASS>[] valueBuilders;

    public EnumeratedDistributionGeneratorBuilder(Class<CLASS> fieldType) {
        super(fieldType);
    }

    @Override
    public Generator<CLASS> build() {
        if (this.values == null ^ this.valueBuilders != null) {
            throw new IllegalArgumentException("either values or builders must be specified");
        }
        if (this.values != null) {
            Object[] fixValues = (Object[])this.values.clone();
            int len = this.values.length;
            if (this.weights != null) {
                if (this.weights.length != len) {
                    throw new IllegalArgumentException("number of weights differ from the number of values");
                }
                double[] cumulativeProbabilities = this.buildCumProbs();
                this.setup(randomSequence -> {
                    int index = Arrays.binarySearch(cumulativeProbabilities, randomSequence.nextDouble());
                    if (index < 0) {
                        index = -index - 1;
                    }
                    return fixValues[index];
                });
            } else {
                this.setup(randomSequence -> fixValues[randomSequence.nextInt(len)]);
            }
        } else if (this.valueBuilders != null) {
            Generator[] genValues = (Generator[])Arrays.stream(this.valueBuilders).map(AbstractGeneratorBuilder::build).toArray(Generator[]::new);
            int len = genValues.length;
            if (this.weights != null) {
                if (this.weights.length != len) {
                    throw new IllegalArgumentException("number of weights differ from the number of values");
                }
                double[] cumulativeProbabilities = this.buildCumProbs();
                this.setup(randomSequence -> {
                    int index = Arrays.binarySearch(cumulativeProbabilities, randomSequence.nextDouble());
                    if (index < 0) {
                        index = -index - 1;
                    }
                    return genValues[index].generate((RandomSequence)randomSequence);
                });
            } else {
                this.setup(randomSequence -> genValues[randomSequence.nextInt(len)].generate((RandomSequence)randomSequence));
            }
        }
        return super.build();
    }

    private double[] buildCumProbs() {
        double[] cumulativeProbabilities = MathArrays.normalizeArray((double[])this.weights, (double)1.0);
        double sum = 0.0;
        for (int i = 0; i < cumulativeProbabilities.length; ++i) {
            cumulativeProbabilities[i] = sum += cumulativeProbabilities[i];
        }
        return cumulativeProbabilities;
    }

    @Override
    protected void assertFieldTypeSupported() {
    }

    public EnumeratedDistributionGeneratorBuilder<CLASS> weights(double ... weights) {
        this.weights = weights;
        return this;
    }

    public EnumeratedDistributionGeneratorBuilder<CLASS> weights(long ... weights) {
        this.weights = Arrays.stream(weights).mapToDouble(l -> l).toArray();
        return this;
    }

    public EnumeratedDistributionGeneratorBuilder<CLASS> values(CLASS ... values) {
        this.values = values;
        return this;
    }

    public EnumeratedDistributionGeneratorBuilder<CLASS> from(Frequency frequency) {
        return this.from(frequency, v -> v);
    }

    public <K extends Comparable<K>> EnumeratedDistributionGeneratorBuilder<CLASS> from(Frequency frequency, Function<K, CLASS> keyToValueMapper) {
        int size = frequency.getUniqueCount();
        this.values = new Object[size];
        this.weights = new double[size];
        boolean hasWeights = false;
        Iterator entryIterator = frequency.entrySetIterator();
        for (int i = 0; i < size; ++i) {
            Map.Entry e = (Map.Entry)entryIterator.next();
            this.values[i] = keyToValueMapper.apply((Comparable)e.getKey());
            long value = (Long)e.getValue();
            if (value != 1L) {
                hasWeights = true;
            }
            this.weights[i] = value;
        }
        if (!hasWeights) {
            this.weights = null;
        }
        return this;
    }

    public EnumeratedDistributionGeneratorBuilder<CLASS> valuesFromCSVResource(String resource) {
        return this.valuesFromCSVResource(resource, v -> v);
    }

    public EnumeratedDistributionGeneratorBuilder<CLASS> valuesFromCSVResource(String resource, Function<String, CLASS> keyToValueMapper) {
        Frequency frequency = DistributionUtils.fromCsvResource(resource);
        return this.from(frequency, keyToValueMapper);
    }

    public EnumeratedDistributionGeneratorBuilder<CLASS> generators(AbstractGeneratorBuilder<? extends CLASS> ... values) {
        this.valueBuilders = values;
        return this;
    }
}

