/*
 * Decompiled with CFR 0.152.
 */
package com.arboratum.beangen.core;

import com.arboratum.beangen.core.AbstractGeneratorBuilder;
import com.arboratum.beangen.distribution.CommonsMathIntegerDistribution;
import com.arboratum.beangen.distribution.UniformIntegerDistribution;
import com.google.common.collect.ImmutableSet;
import org.apache.commons.math3.distribution.IntegerDistribution;

public class IntegerGeneratorBuilder<VALUE extends Number>
extends AbstractGeneratorBuilder<VALUE> {
    public static final ImmutableSet<Class> SUPPORTED_TYPES = ImmutableSet.of(Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, (Object[])new Class[]{Long.TYPE, Long.class});

    public IntegerGeneratorBuilder(Class<VALUE> fieldType) {
        super(fieldType);
    }

    public IntegerGeneratorBuilder<VALUE> uniform() {
        this.setup(new UniformIntegerDistribution<Object>(null, null, this.fieldType).build());
        return this;
    }

    public IntegerGeneratorBuilder<VALUE> uniform(VALUE min, VALUE max) {
        this.setup(new UniformIntegerDistribution<VALUE>(min, max, this.fieldType).build());
        return this;
    }

    public IntegerGeneratorBuilder<VALUE> distribution(IntegerDistribution distribution) {
        this.setup(new CommonsMathIntegerDistribution(distribution, true, this.fieldType).build());
        return this;
    }
}

