/*
 * Decompiled with CFR 0.152.
 */
package com.arboratum.beangen.database;

import com.arboratum.beangen.Generator;
import com.arboratum.beangen.database.AbstractEntry;
import com.arboratum.beangen.database.DataSetBuilder;
import com.arboratum.beangen.database.DataView;
import com.arboratum.beangen.database.Entry;
import com.arboratum.beangen.database.FilteredDataView;
import com.arboratum.beangen.database.UpdateGenerator;
import com.arboratum.beangen.database.UpdateOf;
import com.arboratum.beangen.util.RandomSequence;
import com.google.common.primitives.Bytes;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.roaringbitmap.RoaringBitmap;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SynchronousSink;
import reactor.core.publisher.TopicProcessor;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class DataSet<ENTRY>
implements DataView<ENTRY> {
    private final Generator<ENTRY> entryGenerator;
    private final UpdateGenerator<ENTRY> updateGenerator;
    private final DataView.CreateTrigger<ENTRY>[] createTriggers;
    private final DataView.UpdateTrigger<ENTRY>[] updateTriggers;
    private final Scheduler scheduler;
    private final int offset;
    private final Operation NON_GENERATABLE_FOR_ID = new Operation(-1, null);
    private final TopicProcessor<Operation> operationAcks = TopicProcessor.share((String)"Operation-Acks", (int)8);
    private final Generator<DataView.OpCode> operationGenerator;
    private volatile byte[] versions;
    private volatile int lastIndex = -1;
    private volatile int size;
    private boolean feedBuilt = false;

    public static <T> DataSetBuilder<T> builder() {
        return new DataSetBuilder();
    }

    @Override
    public Class<ENTRY> getEntryType() {
        return this.entryGenerator.getType();
    }

    public EntryImpl selectOne(RandomSequence r) {
        int elementIndex;
        byte version;
        do {
            if (this.size != 0) continue;
            return null;
        } while ((version = this.versions[elementIndex = r.nextInt(this.lastIndex + 1)]) < 0);
        return new EntryImpl(elementIndex, version);
    }

    public Entry get(int elementIndex) {
        return new EntryImpl(elementIndex, this.versions[elementIndex]);
    }

    @Override
    public Generator<ENTRY> random() {
        return new Generator<ENTRY>(this.getEntryType()){

            @Override
            public ENTRY generate(RandomSequence register) {
                return DataSet.this.selectOne(register).lastVersion().block();
            }
        };
    }

    DataSet(Generator<DataView.OpCode> operationGenerator, byte[] versions, int lastIndex, Generator<ENTRY> entryGenerator, UpdateGenerator<ENTRY> updateGenerator, DataView.CreateTrigger<ENTRY>[] createTriggers, DataView.UpdateTrigger<ENTRY>[] updateTriggers, Scheduler scheduler, int offset) {
        this.entryGenerator = entryGenerator;
        this.versions = versions;
        this.lastIndex = lastIndex;
        this.size = this.countActive(versions);
        this.operationGenerator = operationGenerator;
        this.updateGenerator = updateGenerator;
        this.createTriggers = createTriggers;
        this.updateTriggers = updateTriggers;
        this.scheduler = scheduler;
        this.offset = offset;
    }

    private int countActive(byte[] versions) {
        int c = 0;
        for (byte v : versions) {
            if (v <= 0) continue;
            ++c;
        }
        return c;
    }

    DataSet(Generator<DataView.OpCode> operationGenerator) {
        this(operationGenerator, new byte[0], -1, null, null, null, null, Schedulers.single(), 0);
    }

    @Override
    public Flux<Entry<ENTRY>> traverseDataSet(boolean includeDeleted) {
        Flux entryFlux = Flux.range((int)0, (int)(this.lastIndex + 1)).map(i -> {
            byte v = this.versions[i];
            return new EntryImpl((int)i, v);
        });
        if (!includeDeleted) {
            entryFlux = entryFlux.filter(Entry::isLive);
        }
        return entryFlux;
    }

    @Override
    public Flux<Operation> buildOperationFeed(boolean autoAck) {
        if (this.feedBuilt) {
            throw new IllegalStateException("A feed can be built only once");
        }
        this.feedBuilt = true;
        if (!autoAck) {
            this.operationAcks.subscribe(rec$ -> ((Operation)rec$).synchronousAck());
        }
        Flux operationFlux = Flux.generate((Callable)new Callable<DataSetFutureState>(){

            @Override
            public DataSetFutureState call() throws Exception {
                return new DataSetFutureState(DataSet.this.lastIndex, DataSet.this.versions);
            }
        }, (BiFunction)new BiFunction<DataSetFutureState, SynchronousSink<Operation>, DataSetFutureState>(){

            @Override
            public DataSetFutureState apply(DataSetFutureState state, SynchronousSink<Operation> synchronousSink) {
                int id = state.id;
                int lastIndex = state.lastIndex;
                int size = state.size;
                RandomSequence randomSequence = new RandomSequence(id);
                DataView.OpCode opCode = lastIndex == -1 || size == 0 ? DataView.OpCode.CREATE : (DataView.OpCode)((Object)DataSet.this.operationGenerator.generate(randomSequence));
                switch (opCode) {
                    case CREATE: {
                        int index = lastIndex + 1;
                        DataSetFutureState.access$1602(state, Bytes.ensureCapacity((byte[])state.versions, (int)(index + 1), (int)1024));
                        ((DataSetFutureState)state).versions[index] = 1;
                        state.size++;
                        state.lastIndex = index;
                        state.existing.add(index);
                        synchronousSink.next((Object)new Operation(id, new EntryImpl(index, 1)));
                        break;
                    }
                    case DELETE: 
                    case UPDATE: {
                        byte version;
                        int select = state.existing.select(randomSequence.nextInt(size));
                        if (opCode == DataView.OpCode.UPDATE) {
                            ((DataSetFutureState)state).versions[select] = version = (byte)(state.versions[select] + 1);
                        } else {
                            ((DataSetFutureState)state).versions[select] = version = (byte)(-state.versions[select]);
                            state.existing.remove(select);
                            state.size--;
                        }
                        synchronousSink.next((Object)new Operation(id, new EntryImpl(select, version)));
                        break;
                    }
                    default: {
                        throw new RuntimeException("This should never occur");
                    }
                }
                state.id++;
                return state;
            }
        }).subscribeOn(this.scheduler);
        if (autoAck) {
            operationFlux = operationFlux.doOnNext(rec$ -> ((Operation)rec$).synchronousAck());
        }
        return operationFlux;
    }

    private Mono<ENTRY> getEntry(int id) {
        byte version = this.versions[id];
        if (version < 0) {
            return Mono.empty();
        }
        return new EntryImpl(id, version).lastVersion();
    }

    byte[] getVersions() {
        return this.versions;
    }

    int getLastIndex() {
        return this.lastIndex;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public <T> DataView<T> transformedView(Function<ENTRY, T> transformFunction, Class<T> targetType) {
        return FilteredDataView.createTransformedDataSet(this, transformFunction, targetType);
    }

    @Override
    public DataView<ENTRY> filteredView(Predicate<ENTRY> acceptPredicate) {
        return FilteredDataView.createFilteredDataSet(this, acceptPredicate);
    }

    static /* synthetic */ byte[] access$702(DataSet x0, byte[] x1) {
        x0.versions = x1;
        return x1;
    }

    private static class DataSetFutureState {
        private int id = 0;
        private int lastIndex;
        private byte[] versions;
        private int size;
        private RoaringBitmap existing;

        public DataSetFutureState(int lastIndex, byte[] versions) {
            this.lastIndex = lastIndex;
            this.versions = Arrays.copyOf(versions, versions.length);
            this.existing = new RoaringBitmap();
            for (int i = 0; i < lastIndex; ++i) {
                if (versions[i] <= 0) continue;
                this.existing.add(i);
            }
            this.size = this.existing.getCardinality();
        }

        static /* synthetic */ byte[] access$1602(DataSetFutureState x0, byte[] x1) {
            x0.versions = x1;
            return x1;
        }
    }

    public class Operation {
        private final int sequenceId;
        private final EntryImpl entry;
        private boolean toAck = true;

        public Operation(int sequenceId, EntryImpl entry) {
            this.sequenceId = sequenceId;
            this.entry = entry;
        }

        public int getSequenceId() {
            return this.sequenceId;
        }

        public Entry<ENTRY> getEntry() {
            return this.entry;
        }

        public void ack() {
            DataSet.this.operationAcks.onNext((Object)this);
        }

        private void synchronousAck() {
            if (this.toAck) {
                DataView.OpCode opCode = this.entry.getLastOperation();
                DataSet.access$702(DataSet.this, Bytes.ensureCapacity((byte[])DataSet.this.versions, (int)(this.entry.elementIndex + 1), (int)1024));
                ((DataSet)DataSet.this).versions[((EntryImpl)this.entry).elementIndex] = this.entry.elementVersion;
                if (this.entry.elementVersion == 1) {
                    DataSet.this.lastIndex = Math.max(DataSet.this.lastIndex, this.entry.elementIndex);
                }
                switch (opCode) {
                    case CREATE: {
                        DataSet.this.size++;
                        break;
                    }
                    case DELETE: {
                        DataSet.this.size--;
                    }
                }
            } else {
                throw new IllegalStateException("The operation was acked 2 times :" + this);
            }
        }

        public String toString() {
            return "Operation{sequenceId=" + this.sequenceId + ", entry=" + this.entry + '}';
        }
    }

    private class EntryImpl
    extends AbstractEntry<ENTRY>
    implements Entry<ENTRY> {
        private final int elementIndex;
        private final byte elementVersion;

        private EntryImpl(int elementIndex, byte elementVersion) {
            this.elementIndex = elementIndex;
            this.elementVersion = elementVersion;
        }

        @Override
        public DataView.OpCode getLastOperation() {
            if (this.elementVersion < 0) {
                return DataView.OpCode.DELETE;
            }
            if (this.elementVersion == 1) {
                return DataView.OpCode.CREATE;
            }
            return DataView.OpCode.UPDATE;
        }

        public String toString() {
            return "Entry{elementIndex=" + this.elementIndex + ", elementVersion=" + this.elementVersion + '}';
        }

        @Override
        public Flux<Tuple2<UpdateOf<ENTRY>, ENTRY>> buildAllUpdatesAndEntry() {
            int v = Math.abs(this.elementVersion);
            int elementIndex = this.elementIndex;
            Generator entryGenerator = DataSet.this.entryGenerator;
            DataView.CreateTrigger[] createTriggers = DataSet.this.createTriggers;
            return Flux.create(entryFluxSink -> {
                Object value = entryGenerator.generate(elementIndex + DataSet.this.offset);
                if (createTriggers != null) {
                    for (DataView.CreateTrigger trigger : createTriggers) {
                        trigger.apply(elementIndex, value);
                    }
                }
                entryFluxSink.next((Object)Tuples.of(null, value));
                if (v > 1) {
                    RandomSequence seq = new RandomSequence(elementIndex + DataSet.this.offset);
                    for (byte i = 2; i <= v; i = (byte)((byte)(i + 1))) {
                        UpdateOf update = DataSet.this.updateGenerator.generate(value, seq);
                        if (DataSet.this.updateTriggers != null) {
                            for (DataView.UpdateTrigger trigger : DataSet.this.updateTriggers) {
                                trigger.apply(elementIndex, i, update);
                            }
                        }
                        update.apply(value);
                        entryFluxSink.next((Object)Tuples.of(update, value));
                    }
                }
                entryFluxSink.complete();
            });
        }

        @Override
        public boolean isLive() {
            return this.elementVersion > 0;
        }

        @Override
        public boolean isDeleted() {
            return this.elementVersion <= 0;
        }

        @Override
        public int getElementIndex() {
            return this.elementIndex;
        }

        @Override
        public byte getElementVersion() {
            return this.elementVersion;
        }

        @Override
        public EntryRef getRef() {
            return new EntryRef(this.elementIndex, DataSet.this);
        }

        @Override
        public DataSet getDataSet() {
            return DataSet.this;
        }
    }

    public static class EntryRef<ENTRY> {
        private final int elementIndex;
        private final DataSet<ENTRY> dataSet;

        EntryRef(int elementIndex, DataSet dataSet) {
            this.elementIndex = elementIndex;
            this.dataSet = dataSet;
        }

        public Entry<ENTRY> getCurrent() {
            return this.dataSet.get(this.elementIndex);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EntryRef entryRef = (EntryRef)o;
            return this.elementIndex == entryRef.elementIndex && Objects.equals(this.dataSet, entryRef.dataSet);
        }

        public int hashCode() {
            return Objects.hash(this.elementIndex, this.dataSet);
        }
    }
}

