/*
 * Decompiled with CFR 0.152.
 */
package com.arboratum.beangen.database;

import com.arboratum.beangen.BaseBuilders;
import com.arboratum.beangen.Generator;
import com.arboratum.beangen.database.DataSet;
import com.arboratum.beangen.database.DataView;
import com.arboratum.beangen.database.UpdateGenerator;
import com.google.common.primitives.Bytes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.stat.Frequency;
import org.apache.commons.math3.stat.inference.ChiSquareTest;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public strictfp class DataSetBuilder<T> {
    private int offset;
    private int numInitialEntries;
    private Generator<DataView.OpCode> initOpGenerator;
    private Generator<DataView.OpCode> updateOpGenerator;
    private Generator<T> entryGenerator;
    private UpdateGenerator<T> updateGenerator;
    private List<DataView.CreateTrigger<T>> createTriggers = new ArrayList<DataView.CreateTrigger<T>>();
    private List<DataView.UpdateTrigger<T>> updateTriggers = new ArrayList<DataView.UpdateTrigger<T>>();
    private Scheduler scheduler = Schedulers.single();

    public DataSetBuilder<T> offset(int skip) {
        this.offset = skip;
        return this;
    }

    public DataSetBuilder<T> of(int numEntries) {
        this.numInitialEntries = numEntries;
        return this;
    }

    public DataSetBuilder<T> initiallyGeneratedBy(double weightCreate, double weigthUpdate, double weightDelete) {
        this.initOpGenerator = BaseBuilders.enumerated(DataView.OpCode.class).values((DataView.OpCode[])DataView.OpCode.values()).weights(weightCreate, weigthUpdate, weightDelete).build();
        return this;
    }

    public DataSetBuilder<T> thenUpdatedWith(double weightCreate, double weigthUpdate, double weightDelete) {
        this.updateOpGenerator = BaseBuilders.enumerated(DataView.OpCode.class).values((DataView.OpCode[])DataView.OpCode.values()).weights(weightCreate, weigthUpdate, weightDelete).build();
        return this;
    }

    public DataSetBuilder<T> withEntryGenerator(Generator<T> entryGenerator) {
        this.entryGenerator = entryGenerator;
        return this;
    }

    public DataSetBuilder<T> withUpdateGenerator(UpdateGenerator<T> updateGenerator) {
        this.updateGenerator = updateGenerator;
        return this;
    }

    public DataSet<T> build() {
        Frequency previous = new Frequency();
        previous.addValue(1);
        if (this.initOpGenerator != null) {
            DataSet monteCarloSet = new DataSet(this.initOpGenerator);
            Iterable dataSetOperations = monteCarloSet.buildOperationFeed(true).toIterable();
            int i = 0;
            System.out.print("Performing montecarlo procedure to estimate the version distribution");
            for (DataSet.Operation entry : dataSetOperations) {
                double v;
                if (++i % 100000 != 0) continue;
                System.out.print(".");
                Frequency frequencies = new Frequency();
                for (int j = 0; j <= monteCarloSet.getLastIndex(); ++j) {
                    byte version = monteCarloSet.getVersions()[j];
                    frequencies.addValue((int)version);
                }
                if (previous != null && (v = this.chiSquareTest(previous, frequencies)) > 0.999999) {
                    System.out.println(". Converged !");
                    previous = frequencies;
                    break;
                }
                previous = frequencies;
            }
        }
        Generator<Long> generator = BaseBuilders.enumerated(Long.class).from(previous).build();
        double percentDeleted = previous.getCumPct(0);
        int required = this.numInitialEntries;
        byte[] versions = new byte[(int)((double)this.numInitialEntries / (1.0 - percentDeleted))];
        int j = 0;
        while (required > 0) {
            byte v;
            versions = Bytes.ensureCapacity((byte[])versions, (int)(j + 1), (int)1024);
            versions[j] = v = generator.generate(j + this.offset).byteValue();
            if (v > 0) {
                --required;
            }
            ++j;
        }
        return new DataSet<T>(this.updateOpGenerator, versions, j - 1, this.entryGenerator, this.updateGenerator, this.createTriggers.size() == 0 ? null : this.createTriggers.toArray(new DataView.CreateTrigger[0]), this.updateTriggers.size() == 0 ? null : this.updateTriggers.toArray(new DataView.UpdateTrigger[0]), this.scheduler, this.offset);
    }

    private double chiSquareTest(Frequency previous, Frequency current) {
        int uniqueCount = current.getUniqueCount();
        long[] countsCurrent = new long[uniqueCount];
        long[] countsPrevious = new long[uniqueCount];
        Iterator entryIterator = current.entrySetIterator();
        int i = 0;
        while (entryIterator.hasNext()) {
            Map.Entry e = (Map.Entry)entryIterator.next();
            countsCurrent[i] = (Long)e.getValue();
            countsPrevious[i] = previous.getCount((Comparable)e.getKey());
            ++i;
        }
        return new ChiSquareTest().chiSquareTestDataSetsComparison(countsCurrent, countsPrevious);
    }

    public DataSetBuilder<T> onCreate(DataView.CreateTrigger<T> trigger) {
        this.createTriggers.add(trigger);
        return this;
    }

    public DataSetBuilder<T> onUpdate(DataView.UpdateTrigger<T> trigger) {
        this.updateTriggers.add(trigger);
        return this;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }
}

