/*
 * Decompiled with CFR 0.152.
 */
package com.arboratum.beangen.database;

import com.arboratum.beangen.database.DataSet;
import com.arboratum.beangen.database.DataSetBuilder;
import com.arboratum.beangen.database.DataView;
import com.arboratum.beangen.database.UnionDataView;
import com.google.common.base.Stopwatch;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class Database {
    private Map<String, DataSetBuilder> dataSetBuilders = new HashMap<String, DataSetBuilder>();
    private Map<String, DataView> dataSets = new HashMap<String, DataView>();

    public <T> void addDataSet(String name, DataSetBuilder<T> dataset) {
        this.dataSetBuilders.put(name, dataset);
    }

    public <T> DataView createUnionView(String name, Class<T> type, String ... names) {
        DataView[] dataViews = (DataView[])Stream.of(names).map(this::getDataView).toArray(DataView[]::new);
        UnionDataView<T> tUnionView = new UnionDataView<T>(type, dataViews);
        this.dataSets.put(name, tUnionView);
        return tUnionView;
    }

    public <T> DataView createUnionView(String name, String ... names) {
        DataView[] dataViews = (DataView[])Stream.of(names).map(this::getDataView).toArray(DataView[]::new);
        UnionDataView tUnionView = new UnionDataView(dataViews);
        this.dataSets.put(name, tUnionView);
        return tUnionView;
    }

    public <T> DataView<T> getDataView(String dataSetName) {
        DataSet dataSet = this.dataSets.get(dataSetName);
        if (dataSet == null) {
            DataSetBuilder builder = this.dataSetBuilders.remove(dataSetName);
            if (builder == null) {
                throw new IllegalArgumentException("Dataset with name '" + dataSetName + "' not defined");
            }
            dataSet = builder.build();
            this.dataSets.put(dataSetName, dataSet);
        }
        return dataSet;
    }

    public <T> void onCreate(String dataSet, DataView.CreateTrigger<T> trigger) {
        this.dataSetBuilders.get(dataSet).onCreate(trigger);
    }

    public <T> void onUpdate(String dataSet, DataView.UpdateTrigger<T> trigger) {
        this.dataSetBuilders.get(dataSet).onUpdate(trigger);
    }

    public void initialize() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        long count = 0L;
        Optional first = this.dataSetBuilders.entrySet().stream().findFirst();
        while (first.isPresent()) {
            Map.Entry builder = (Map.Entry)first.get();
            DataSet dataSet = ((DataSetBuilder)builder.getValue()).build();
            count += (long)dataSet.getSize();
            this.dataSets.put((String)builder.getKey(), dataSet);
            this.dataSetBuilders.remove(builder.getKey());
            first = this.dataSetBuilders.entrySet().stream().findFirst();
        }
        System.out.println("Initialize database with total entries: " + count + " in " + stopwatch.stop());
    }
}

