/*
 * Decompiled with CFR 0.152.
 */
package com.arboratum.beangen.database;

import com.arboratum.beangen.Generator;
import com.arboratum.beangen.database.DataSet;
import com.arboratum.beangen.database.DataView;
import com.arboratum.beangen.database.Entry;
import com.arboratum.beangen.database.UpdateOf;
import com.arboratum.beangen.util.AtomicBitSet;
import com.arboratum.beangen.util.RandomSequence;
import java.util.function.Function;
import java.util.function.Predicate;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

class FilteredDataView<S, T>
implements DataView<T> {
    private final DataSet<S> source;
    private final Function<Entry<S>, Entry<T>> predicateTranform;
    private final Class<T> targetType;
    private final boolean cacheFilter;
    private final AtomicBitSet filter;

    protected static <S, T> FilteredDataView<S, T> createTransformedDataSet(DataSet<S> source, Function<S, T> transform, Class<T> targetType) {
        return new FilteredDataView<S, T>(source, sEntry -> new TransformedEntry(sEntry, transform), targetType, false);
    }

    protected static <T> FilteredDataView<T, T> createFilteredDataSet(DataSet<T> source, Predicate<T> predicate) {
        return new FilteredDataView<T, T>(source, sEntry -> {
            Object value = sEntry.lastVersion().block();
            if (predicate.test(value)) {
                return sEntry;
            }
            return null;
        }, source.getEntryType(), true);
    }

    private FilteredDataView(DataSet<S> source, Function<Entry<S>, Entry<T>> predicateTranform, Class<T> targetType, boolean cacheFilter) {
        this.source = source;
        this.predicateTranform = predicateTranform;
        this.targetType = targetType;
        this.cacheFilter = cacheFilter;
        this.filter = cacheFilter ? new AtomicBitSet() : null;
    }

    @Override
    public Class<T> getEntryType() {
        return this.targetType;
    }

    @Override
    public Entry<T> selectOne(RandomSequence r) {
        return this.doSelectOne(r);
    }

    private Entry<T> doSelectOne(RandomSequence root) {
        RandomSequence r = root.fork();
        while (this.source.getSize() != 0) {
            int elementIndex = r.nextInt(this.source.getLastIndex() + 1);
            if (this.cacheFilter && this.filter.get(elementIndex)) {
                if (this.filter.countSet() != this.source.getSize()) continue;
                return null;
            }
            Entry entry = this.source.get(elementIndex);
            if (entry.isDeleted()) continue;
            Entry<T> filteredEntry = this.predicateTranform.apply(entry);
            if (filteredEntry != null) {
                return filteredEntry;
            }
            if (!this.cacheFilter) continue;
            this.filter.set(elementIndex);
        }
        return null;
    }

    @Override
    public Generator<T> random() {
        return new Generator<T>(this.getEntryType()){

            @Override
            public T generate(RandomSequence register) {
                return FilteredDataView.this.doSelectOne(register).lastVersion().block();
            }
        };
    }

    @Override
    public Flux<Entry<T>> traverseDataSet(boolean includeDeleted) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public Flux<DataSet.Operation> buildOperationFeed(boolean autoAck) {
        throw new UnsupportedOperationException("UnsupportedOperationException on filtered view");
    }

    @Override
    public int getSize() {
        return this.source.getSize();
    }

    @Override
    public <T1> DataView<T1> transformedView(Function<T, T1> transformFunction, Class<T1> targetType) {
        return new FilteredDataView<S, T>(this.source, sEntry -> {
            Entry<T> tEntry = this.predicateTranform.apply((Entry<S>)sEntry);
            if (tEntry == null) {
                return null;
            }
            return new TransformedEntry(tEntry, transformFunction);
        }, targetType, false);
    }

    @Override
    public DataView<T> filteredView(Predicate<T> acceptPredicate) {
        return new FilteredDataView<S, T>(this.source, sEntry -> {
            Entry<T> tEntry = this.predicateTranform.apply((Entry<S>)sEntry);
            if (tEntry == null) {
                return null;
            }
            Object value = tEntry.lastVersion().block();
            if (acceptPredicate.test(value)) {
                return tEntry;
            }
            return null;
        }, this.getEntryType(), true);
    }

    private static class TransformedEntry<S, T>
    implements Entry<T> {
        private final Entry<S> entry;
        private final Function<? super S, ? extends T> transformFunction;
        private Mono<T> lastVersion;

        public TransformedEntry(Entry<S> entry, Function<? super S, ? extends T> transformFunction) {
            this.entry = entry;
            this.transformFunction = transformFunction;
        }

        @Override
        public DataView.OpCode getLastOperation() {
            return this.entry.getLastOperation();
        }

        @Override
        public Flux<T> allVersions() {
            return this.entry.allVersions().map(this.transformFunction);
        }

        @Override
        public Flux<Tuple2<UpdateOf<T>, T>> allUpdatesAndEntry() {
            throw new UnsupportedOperationException("UnsupportedOperationException on transformed view");
        }

        @Override
        public Mono<T> lastVersion() {
            if (this.lastVersion == null) {
                this.lastVersion = this.entry.lastVersion().map(this.transformFunction).cache();
            }
            return this.lastVersion;
        }

        @Override
        public Mono<UpdateOf<T>> lastUpdate() {
            throw new UnsupportedOperationException("UnsupportedOperationException on transformed view");
        }

        @Override
        public boolean isLive() {
            return this.entry.isLive();
        }

        @Override
        public boolean isDeleted() {
            return this.entry.isDeleted();
        }

        @Override
        public int getElementIndex() {
            return this.entry.getElementIndex();
        }

        @Override
        public byte getElementVersion() {
            return this.entry.getElementVersion();
        }

        @Override
        public DataSet.EntryRef getRef() {
            final DataSet.EntryRef ref = this.entry.getRef();
            return new DataSet.EntryRef(this.entry.getElementIndex(), this.entry.getDataSet()){

                public Entry getCurrent() {
                    return new TransformedEntry(ref.getCurrent(), transformFunction);
                }
            };
        }

        @Override
        public DataSet getDataSet() {
            return this.entry.getDataSet();
        }
    }
}

