/*
 * Decompiled with CFR 0.152.
 */
package com.arboratum.beangen.database;

import com.arboratum.beangen.Generator;
import com.arboratum.beangen.database.DataSet;
import com.arboratum.beangen.database.DataView;
import com.arboratum.beangen.database.Entry;
import com.arboratum.beangen.util.RandomSequence;
import com.arboratum.beangen.util.ReflectionUtils;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import reactor.core.publisher.Flux;
import reactor.core.publisher.SynchronousSink;

class UnionDataView<T>
implements DataView<T> {
    private final DataView[] children;
    private final Class<T> type;

    public UnionDataView(Class<T> type, DataView<? extends T> ... dataViews) {
        this.children = dataViews;
        this.type = type;
    }

    public UnionDataView(DataView<? extends T> ... dataViews) {
        this.children = dataViews;
        List<Class<?>> types = ReflectionUtils.commonSuperClass((Class[])Stream.of(this.children).map(DataView::getEntryType).distinct().toArray(Class[]::new));
        this.type = types.get(0);
    }

    @Override
    public Class<T> getEntryType() {
        return this.type;
    }

    @Override
    public Entry<T> selectOne(RandomSequence r) {
        int index = this.selectChildIndexRandBySize(r, null);
        if (index == -1) {
            return null;
        }
        Entry entry = this.children[index].selectOne(r);
        if (entry == null) {
            BitSet exclude = new BitSet();
            while (entry == null) {
                exclude.set(index);
                index = this.selectChildIndexRandBySize(r, null);
                if (index == -1) {
                    return null;
                }
                entry = this.children[index].selectOne(r);
            }
        }
        return entry;
    }

    private int selectChildIndexRandBySize(RandomSequence r, BitSet exclude) {
        long[] ranges = new long[this.children.length];
        int[] nonEmptySets = new int[this.children.length];
        long acc = 0L;
        int j = 0;
        int childrenLength = this.children.length;
        for (int i = 0; i < childrenLength; ++i) {
            DataView child = this.children[i];
            int size = child.getSize();
            if (size <= 0 || exclude != null && exclude.get(i)) continue;
            ranges[j] = (acc += (long)size) - 1L;
            nonEmptySets[j] = i;
            ++j;
        }
        if (j == 0) {
            return -1;
        }
        long rnd = r.nextLong(acc);
        int index = Arrays.binarySearch(ranges, 0, j, rnd);
        if (index < 0) {
            index = -index - 1;
        }
        return nonEmptySets[index];
    }

    @Override
    public Generator<T> random() {
        return new Generator<T>(this.getEntryType()){

            @Override
            public T generate(RandomSequence register) {
                Entry entry = UnionDataView.this.selectOne(register);
                return entry != null ? entry.lastVersion().block() : null;
            }
        };
    }

    @Override
    public Flux<Entry<T>> traverseDataSet(boolean includeDeleted) {
        return Flux.fromArray((Object[])this.children).concatMap(dataView -> dataView.traverseDataSet(includeDeleted));
    }

    @Override
    public Flux<DataSet.Operation> buildOperationFeed(boolean autoAck) {
        final Iterator[] feeds = (Iterator[])Stream.of(this.children).map(v -> v.buildOperationFeed(autoAck)).map(operationFlux -> operationFlux.toIterable(1L)).map(Iterable::iterator).toArray(Iterator[]::new);
        return Flux.generate((Consumer)new Consumer<SynchronousSink<DataSet.Operation>>(){
            final RandomSequence r = new RandomSequence(0L);

            @Override
            public void accept(SynchronousSink<DataSet.Operation> fluxSink) {
                int index = UnionDataView.this.selectChildIndexRandBySize(this.r, null);
                Iterator feed = index == -1 ? feeds[this.r.nextInt(feeds.length)] : feeds[index];
                try {
                    if (feed.hasNext()) {
                        fluxSink.next(feed.next());
                    }
                }
                catch (Exception e) {
                    if (e instanceof IllegalStateException) {
                        fluxSink.complete();
                    }
                    fluxSink.error((Throwable)e);
                }
            }
        });
    }

    @Override
    public int getSize() {
        return Stream.of(this.children).mapToInt(DataView::getSize).sum();
    }

    @Override
    public <U> DataView<U> transformedView(Function<T, U> transformFunction, Class<U> targetType) {
        DataView[] newChildren = (DataView[])Arrays.stream(this.children).map(v -> v.transformedView(transformFunction, targetType)).toArray(DataView[]::new);
        return new UnionDataView<U>(targetType, newChildren);
    }

    @Override
    public DataView<T> filteredView(Predicate<T> acceptPredicate) {
        DataView[] newChildren = (DataView[])Arrays.stream(this.children).map(v -> v.filteredView(acceptPredicate)).toArray(DataView[]::new);
        return new UnionDataView<T>(this.getEntryType(), newChildren);
    }
}

