/*
 * Decompiled with CFR 0.152.
 */
package com.arboratum.beangen.distribution;

import com.arboratum.beangen.distribution.DecimalDistribution;
import com.arboratum.beangen.util.RandomSequence;
import java.util.function.ToDoubleFunction;
import java.util.stream.DoubleStream;
import org.apache.commons.math3.distribution.RealDistribution;

public class CommonsMathDecimalDistribution<VALUE extends Number>
extends DecimalDistribution<VALUE> {
    private final Double tabulateStep;
    private final RealDistribution distribution;

    public CommonsMathDecimalDistribution(RealDistribution distribution, Double tabulateStep, Class<VALUE> fieldType) {
        super(fieldType);
        this.tabulateStep = tabulateStep;
        this.distribution = distribution;
    }

    @Override
    protected ToDoubleFunction<RandomSequence> buildDoubleFunction() {
        if (this.tabulateStep != null) {
            double step = this.tabulateStep;
            double invStep = 1.0 / step;
            double[] inverseCumulatedProbability = DoubleStream.iterate(0.0, s -> s + this.tabulateStep).map(s -> this.distribution.inverseCumulativeProbability(s)).toArray();
            int maxI = inverseCumulatedProbability.length;
            return r -> {
                int i = (int)Math.round(r.nextDouble() * invStep);
                if (i < 0) {
                    i = -i - 1;
                }
                if (i > maxI) {
                    i = maxI;
                }
                return inverseCumulatedProbability[i];
            };
        }
        return r -> this.distribution.inverseCumulativeProbability(r.nextDouble());
    }
}

