/*
 * Decompiled with CFR 0.152.
 */
package com.arboratum.beangen.distribution;

import com.arboratum.beangen.distribution.IntegerDistribution;
import com.arboratum.beangen.util.RandomSequence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.apache.commons.math3.util.Pair;

public strictfp class CommonsMathIntegerDistribution<VALUE extends Number>
extends IntegerDistribution<VALUE> {
    private final boolean tabulated;
    private final org.apache.commons.math3.distribution.IntegerDistribution distribution;

    public CommonsMathIntegerDistribution(org.apache.commons.math3.distribution.IntegerDistribution distribution, boolean tabulate, Class<VALUE> fieldType) {
        super(fieldType);
        this.tabulated = tabulate;
        this.distribution = distribution;
    }

    @Override
    protected ToLongFunction<RandomSequence> buildLongFunction() {
        ToIntFunction<RandomSequence> toIntFunction = this.buildIntFunction();
        return r -> toIntFunction.applyAsInt((RandomSequence)r);
    }

    @Override
    protected ToIntFunction<RandomSequence> buildIntFunction() {
        if (this.tabulated) {
            ArrayList<Pair> cumProb = new ArrayList<Pair>();
            double lastCum = 0.0;
            int supportUpperBound = this.distribution.inverseCumulativeProbability(0.9999999999999999);
            for (int i = this.distribution.getSupportLowerBound(); i <= supportUpperBound; ++i) {
                double v = this.distribution.cumulativeProbability(i);
                if (v - lastCum < (double)1.110223E-16f) continue;
                lastCum = v;
                cumProb.add(new Pair((Object)i, (Object)v));
            }
            int[] inverseCumulatedProbability = new int[cumProb.size()];
            double[] cumulatedProbalibity = new double[cumProb.size()];
            for (int i = 0; i < cumProb.size(); ++i) {
                inverseCumulatedProbability[i] = (Integer)((Pair)cumProb.get(i)).getFirst();
                cumulatedProbalibity[i] = (Double)((Pair)cumProb.get(i)).getSecond();
            }
            return r -> {
                int i = Arrays.binarySearch(cumulatedProbalibity, r.nextDouble());
                if (i < 0) {
                    i = -i - 1;
                }
                return inverseCumulatedProbability[i];
            };
        }
        return r -> this.distribution.inverseCumulativeProbability(r.nextDouble());
    }
}

