/*
 * Decompiled with CFR 0.152.
 */
package com.arboratum.beangen.distribution;

import com.arboratum.beangen.util.RandomSequence;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;

public abstract class DecimalDistribution<VALUE extends Number> {
    private final Class<VALUE> fieldType;
    protected final int type;
    protected static final int FLOAT = 0;
    protected static final int DOUBLE = 1;

    protected DecimalDistribution(Class<VALUE> fieldType) {
        this.fieldType = fieldType;
        if (fieldType == Double.TYPE || fieldType == Double.class) {
            this.type = 1;
        } else if (fieldType == Float.TYPE || fieldType == Float.class) {
            this.type = 0;
        } else {
            throw new IllegalArgumentException("Invalid type");
        }
    }

    public Function<RandomSequence, VALUE> build() {
        ToDoubleFunction<RandomSequence> toDoubleFunction = this.buildDoubleFunction();
        switch (this.type) {
            case 0: {
                return seq -> Float.valueOf((float)toDoubleFunction.applyAsDouble((RandomSequence)seq));
            }
            case 1: {
                return seq -> toDoubleFunction.applyAsDouble((RandomSequence)seq);
            }
        }
        throw new IllegalArgumentException("Invalid type");
    }

    protected abstract ToDoubleFunction<RandomSequence> buildDoubleFunction();
}

