/*
 * Decompiled with CFR 0.152.
 */
package com.arboratum.beangen.distribution;

import com.arboratum.beangen.util.RandomSequence;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public abstract class IntegerDistribution<VALUE extends Number> {
    private final Class<VALUE> fieldType;
    protected final int type;
    protected static final int BYTE = 0;
    protected static final int SHORT = 1;
    protected static final int INTEGER = 2;
    protected static final int LONG = 3;

    protected IntegerDistribution(Class<VALUE> fieldType) {
        this.fieldType = fieldType;
        if (fieldType == Byte.TYPE || fieldType == Byte.class) {
            this.type = 0;
        } else if (fieldType == Short.TYPE || fieldType == Short.class) {
            this.type = 1;
        } else if (fieldType == Integer.TYPE || fieldType == Integer.class) {
            this.type = 2;
        } else if (fieldType == Long.TYPE || fieldType == Long.class) {
            this.type = 3;
        } else {
            throw new IllegalArgumentException("Invalid type");
        }
    }

    public Function<RandomSequence, VALUE> build() {
        switch (this.type) {
            case 0: {
                ToIntFunction<RandomSequence> toIntFunction = this.buildIntFunction();
                return seq -> (byte)toIntFunction.applyAsInt((RandomSequence)seq);
            }
            case 1: {
                ToIntFunction<RandomSequence> toIntFunction = this.buildIntFunction();
                return seq -> (short)toIntFunction.applyAsInt((RandomSequence)seq);
            }
            case 2: {
                ToIntFunction<RandomSequence> toIntFunction = this.buildIntFunction();
                return seq -> toIntFunction.applyAsInt((RandomSequence)seq);
            }
            case 3: {
                ToLongFunction<RandomSequence> toLongFunction = this.buildLongFunction();
                return seq -> toLongFunction.applyAsLong((RandomSequence)seq);
            }
        }
        throw new IllegalArgumentException("Invalid type");
    }

    protected abstract ToLongFunction<RandomSequence> buildLongFunction();

    protected abstract ToIntFunction<RandomSequence> buildIntFunction();
}

