/*
 * Decompiled with CFR 0.152.
 */
package com.arboratum.beangen.distribution;

import com.arboratum.beangen.util.RandomSequence;
import dk.brics.automaton.Automaton;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.State;
import dk.brics.automaton.Transition;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import org.apache.commons.math3.util.FastMath;

public class RegExpStringGenerator
implements Function<RandomSequence, char[]> {
    private final Node rootNode;

    public RegExpStringGenerator(String regexp) {
        RegExp re = new RegExp(regexp);
        Automaton automaton = re.toAutomaton(true);
        automaton.determinize();
        automaton.reduce();
        if (!automaton.isFinite()) {
            automaton = automaton.intersection(Automaton.makeAnyChar().repeat(0, 20));
            automaton.determinize();
            automaton.reduce();
        }
        this.rootNode = new Node();
        HashMap<State, Node> nodes = new HashMap<State, Node>();
        this.computeCount(this.rootNode, automaton.getInitialState(), nodes);
    }

    private void computeCount(Node node, State state, HashMap<State, Node> nodes) {
        long[] proba;
        NodeTransition[] trans;
        long count = 0L;
        int i = 0;
        int maxLen = 0;
        if (state.isAccept()) {
            trans = new NodeTransition[state.getTransitions().size() + 1];
            proba = new long[trans.length];
            ++count;
            proba[0] = 1L;
            i = 1;
        } else {
            trans = new NodeTransition[state.getTransitions().size()];
            proba = new long[trans.length];
        }
        Set transitions = state.getTransitions();
        TreeSet ordered = new TreeSet((a, b) -> Character.compare(a.getMin(), b.getMin()));
        ordered.addAll(transitions);
        for (Transition t : ordered) {
            long transitionCount = t.getMax() - t.getMin() + 1;
            Node childCount = nodes.get(t.getDest());
            if (childCount == null) {
                childCount = new Node();
                this.computeCount(childCount, t.getDest(), nodes);
            }
            proba[i] = count = FastMath.addExact((long)count, (long)FastMath.multiplyExact((long)transitionCount, (long)childCount.count));
            maxLen = Math.max(maxLen, 1 + childCount.getMaxLen());
            trans[i++] = new NodeTransition(t.getMin(), t.getMax(), childCount);
        }
        node.setCount(count);
        node.setTransitions(trans);
        node.setProba(proba);
        node.setMaxLen(maxLen);
        nodes.put(state, node);
    }

    @Override
    public char[] apply(RandomSequence register) {
        CharBuffer value = CharBuffer.allocate(this.rootNode.getMaxLen());
        NodeTransition transition = this.rootNode.getTransition(register);
        while (transition != null) {
            char c;
            int charRange = transition.getLastChar() - transition.getFirstChar() + 1;
            if (charRange == 1) {
                c = transition.getFirstChar();
            } else {
                int charindex = register.nextInt(charRange);
                c = (char)(transition.getFirstChar() + charindex);
            }
            value.append(c);
            Node next = transition.getNext();
            if (next.transitions.length == 1) {
                transition = next.transitions[0];
                continue;
            }
            transition = next.getTransition(register);
        }
        value.flip();
        char[] result = new char[value.length()];
        System.arraycopy(value.array(), 0, result, 0, value.length());
        return result;
    }

    public String toString() {
        return "RegExpStringGenerator{rootNode=" + this.rootNode + '}';
    }

    private static class Node {
        private long count;
        private int maxLen;
        private long[] proba;
        private NodeTransition[] transitions;

        private Node() {
        }

        public NodeTransition getTransition(RandomSequence register) {
            int index = Arrays.binarySearch(this.proba, register.nextLong(this.count));
            if (index < 0) {
                index = -index - 1;
            }
            return this.transitions[index];
        }

        public void setCount(long count) {
            this.count = count;
        }

        public int getMaxLen() {
            return this.maxLen;
        }

        public void setMaxLen(int maxLen) {
            this.maxLen = maxLen;
        }

        public long[] getProba() {
            return this.proba;
        }

        public void setProba(long[] proba) {
            this.proba = proba;
        }

        public NodeTransition[] getTransitions() {
            return this.transitions;
        }

        public void setTransitions(NodeTransition[] transitions) {
            this.transitions = transitions;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return Double.compare(node.count, this.count) == 0 && this.maxLen == node.maxLen && Arrays.equals(this.proba, node.proba) && Arrays.equals(this.transitions, node.transitions);
        }

        public int hashCode() {
            return Objects.hash(this.count, this.maxLen, this.proba, this.transitions);
        }

        public String toString() {
            return "Node{count=" + this.count + ", maxLen=" + this.maxLen + ", proba=" + Arrays.toString(this.proba) + ", transitions=" + Arrays.toString(this.transitions) + '}';
        }
    }

    private static class NodeTransition {
        private final char firstChar;
        private final char lastChar;
        private final Node next;

        public NodeTransition(char firstChar, char lastChar, Node next) {
            this.firstChar = firstChar;
            this.lastChar = lastChar;
            this.next = next;
        }

        public char getFirstChar() {
            return this.firstChar;
        }

        public char getLastChar() {
            return this.lastChar;
        }

        public Node getNext() {
            return this.next;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeTransition that = (NodeTransition)o;
            return this.firstChar == that.firstChar && this.lastChar == that.lastChar && Objects.equals(this.next, that.next);
        }

        public int hashCode() {
            return Objects.hash(Character.valueOf(this.firstChar), Character.valueOf(this.lastChar), this.next);
        }

        public String toString() {
            return "NodeTransition{firstChar=" + this.firstChar + ", lastChar=" + this.lastChar + ", next=" + this.next + '}';
        }
    }
}

