/*
 * Decompiled with CFR 0.152.
 */
package com.arboratum.beangen.distribution;

import com.arboratum.beangen.distribution.DecimalDistribution;
import com.arboratum.beangen.util.RandomSequence;
import java.util.function.ToDoubleFunction;

public class UniformDecimalDistribution<VALUE extends Number>
extends DecimalDistribution<VALUE> {
    private boolean hasBound = false;
    private double lower;
    private double upper;

    public UniformDecimalDistribution(VALUE minInclusive, VALUE maxInclusive, Class<VALUE> fieldType) {
        super(fieldType);
        if (minInclusive != null) {
            this.lower = ((Number)minInclusive).longValue();
            this.hasBound = true;
        } else {
            this.lower = this.min();
        }
        if (maxInclusive != null) {
            this.upper = ((Number)maxInclusive).longValue();
            this.hasBound = true;
        } else {
            this.upper = this.max();
        }
    }

    private double max() {
        switch (this.type) {
            case 0: {
                return 3.4028234663852886E38;
            }
        }
        return Double.MAX_VALUE;
    }

    private double min() {
        switch (this.type) {
            case 0: {
                return -3.4028234663852886E38;
            }
        }
        return -1.7976931348623157E308;
    }

    @Override
    protected ToDoubleFunction<RandomSequence> buildDoubleFunction() {
        if (this.hasBound) {
            return seq -> {
                double u = seq.nextDouble();
                return u * this.upper + (1.0 - u) * this.lower;
            };
        }
        return RandomSequence::nextDouble;
    }
}

