/*
 * Decompiled with CFR 0.152.
 */
package com.arboratum.beangen.distribution;

import com.arboratum.beangen.distribution.IntegerDistribution;
import com.arboratum.beangen.util.RandomSequence;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public class UniformIntegerDistribution<VALUE extends Number>
extends IntegerDistribution<VALUE> {
    private boolean hasBound = false;
    private long lower;
    private long upper;
    private final long range;

    public UniformIntegerDistribution(VALUE minInclusive, VALUE maxInclusive, Class<VALUE> fieldType) {
        super(fieldType);
        if (minInclusive != null) {
            this.lower = ((Number)minInclusive).longValue();
            this.hasBound = true;
        } else {
            this.lower = UniformIntegerDistribution.minOf(fieldType);
        }
        if (maxInclusive != null) {
            this.upper = ((Number)maxInclusive).longValue();
            this.hasBound = true;
        } else {
            this.upper = UniformIntegerDistribution.maxOf(fieldType);
        }
        this.range = this.upper - this.lower + 1L;
    }

    private static long maxOf(Class<?> fieldType) {
        if (fieldType == Byte.TYPE || fieldType == Byte.class) {
            return 127L;
        }
        if (fieldType == Short.TYPE || fieldType == Short.class) {
            return 32767L;
        }
        if (fieldType == Integer.TYPE || fieldType == Integer.class) {
            return Integer.MAX_VALUE;
        }
        if (fieldType == Long.TYPE || fieldType == Long.class) {
            return Long.MAX_VALUE;
        }
        throw new IllegalArgumentException("Non numeric type");
    }

    private static long minOf(Class<?> fieldType) {
        if (fieldType == Byte.TYPE || fieldType == Byte.class) {
            return -128L;
        }
        if (fieldType == Short.TYPE || fieldType == Short.class) {
            return -32768L;
        }
        if (fieldType == Integer.TYPE || fieldType == Integer.class) {
            return Integer.MIN_VALUE;
        }
        if (fieldType == Long.TYPE || fieldType == Long.class) {
            return Long.MIN_VALUE;
        }
        throw new IllegalArgumentException("Non numeric type");
    }

    @Override
    protected ToLongFunction<RandomSequence> buildLongFunction() {
        if (this.hasBound) {
            if (this.range <= 0L) {
                return seq -> {
                    long r;
                    while ((r = seq.nextLong()) < this.lower || r > this.upper) {
                    }
                    return r;
                };
            }
            return seq -> this.lower + seq.nextLong(this.range);
        }
        return RandomSequence::nextLong;
    }

    @Override
    protected ToIntFunction<RandomSequence> buildIntFunction() {
        if (this.hasBound) {
            return seq -> (int)(this.lower + seq.nextLong(this.range));
        }
        return RandomSequence::nextInt;
    }
}

