/*
 * Decompiled with CFR 0.152.
 */
package com.arboratum.beangen.extended;

import com.arboratum.beangen.BaseBuilders;
import com.arboratum.beangen.Generator;
import com.arboratum.beangen.core.AbstractGeneratorBuilder;
import com.arboratum.beangen.extended.Identity;
import com.arboratum.beangen.util.RandomSequence;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.util.Date;

public class IdentityGeneratorBuilder
extends AbstractGeneratorBuilder<Identity> {
    public static final ImmutableSet<Class> SUPPORTED_TYPES = ImmutableSet.of(Identity.class);
    private static final Generator<Identity.Gender> GENDER = BaseBuilders.anEnum(Identity.Gender.class).uniform().build();
    private static final Generator<Date> DATE_OF_BIRTH = BaseBuilders.aDate().uniform(Date.from(Instant.parse("1926-01-01T00:00:00Z")), Date.from(Instant.parse("2016-01-01T00:00:00Z"))).build();

    public IdentityGeneratorBuilder() {
        super(Identity.class);
    }

    public IdentityGeneratorBuilder country(String iso) {
        CountryConfig countryOfBirth = IdentityGeneratorBuilder.buildCountryConfig(iso);
        this.setup(seq -> {
            Identity.Gender gender = GENDER.generate((RandomSequence)seq);
            Identity identity = new Identity();
            identity.setDateOfBirth(DATE_OF_BIRTH.generate((RandomSequence)seq));
            identity.setGender(gender);
            identity.setCountryOfBirth(countryOfBirth.getCountry());
            if (gender == Identity.Gender.male) {
                identity.setFirstNames(countryOfBirth.getGivenNameMale().generate((RandomSequence)seq));
            } else {
                identity.setFirstNames(countryOfBirth.getGivenNameFemale().generate((RandomSequence)seq));
            }
            identity.setFamilyNames(countryOfBirth.getFamilyName().generate((RandomSequence)seq));
            return identity;
        });
        return this;
    }

    public IdentityGeneratorBuilder all() {
        return this.countries("/generator/country-population.csv");
    }

    public IdentityGeneratorBuilder countries(String resource) {
        Generator<CountryConfig> country = BaseBuilders.enumerated(CountryConfig.class).valuesFromCSVResource(resource, k -> IdentityGeneratorBuilder.buildCountryConfig(k)).build();
        this.setup(seq -> {
            Identity.Gender gender = GENDER.generate((RandomSequence)seq);
            CountryConfig countryOfBirth = (CountryConfig)country.generate((RandomSequence)seq);
            Identity identity = new Identity();
            identity.setDateOfBirth(DATE_OF_BIRTH.generate((RandomSequence)seq));
            identity.setGender(gender);
            identity.setCountryOfBirth(countryOfBirth.getCountry());
            if (gender == Identity.Gender.male) {
                identity.setFirstNames(countryOfBirth.getGivenNameMale().generate((RandomSequence)seq));
            } else {
                identity.setFirstNames(countryOfBirth.getGivenNameFemale().generate((RandomSequence)seq));
            }
            identity.setFamilyNames(countryOfBirth.getFamilyName().generate((RandomSequence)seq));
            return identity;
        });
        return this;
    }

    private static CountryConfig buildCountryConfig(String iso2) {
        iso2 = iso2.toUpperCase();
        return CountryConfig.builder().country(iso2).familyName(BaseBuilders.enumerated(String.class).valuesFromCSVResource("/generator/familyName_" + iso2 + ".csv").build()).givenNameMale(BaseBuilders.enumerated(String.class).valuesFromCSVResource("/generator/givenName_male_" + iso2 + ".csv").build()).givenNameFemale(BaseBuilders.enumerated(String.class).valuesFromCSVResource("/generator/givenName_female_" + iso2 + ".csv").build()).build();
    }

    private static final class CountryConfig {
        private final String country;
        private final Generator<String> givenNameMale;
        private final Generator<String> givenNameFemale;
        private final Generator<String> familyName;

        @ConstructorProperties(value={"country", "givenNameMale", "givenNameFemale", "familyName"})
        CountryConfig(String country, Generator<String> givenNameMale, Generator<String> givenNameFemale, Generator<String> familyName) {
            this.country = country;
            this.givenNameMale = givenNameMale;
            this.givenNameFemale = givenNameFemale;
            this.familyName = familyName;
        }

        public static CountryConfigBuilder builder() {
            return new CountryConfigBuilder();
        }

        public String getCountry() {
            return this.country;
        }

        public Generator<String> getGivenNameMale() {
            return this.givenNameMale;
        }

        public Generator<String> getGivenNameFemale() {
            return this.givenNameFemale;
        }

        public Generator<String> getFamilyName() {
            return this.familyName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CountryConfig)) {
                return false;
            }
            CountryConfig other = (CountryConfig)o;
            String this$country = this.getCountry();
            String other$country = other.getCountry();
            if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                return false;
            }
            Generator<String> this$givenNameMale = this.getGivenNameMale();
            Generator<String> other$givenNameMale = other.getGivenNameMale();
            if (this$givenNameMale == null ? other$givenNameMale != null : !this$givenNameMale.equals(other$givenNameMale)) {
                return false;
            }
            Generator<String> this$givenNameFemale = this.getGivenNameFemale();
            Generator<String> other$givenNameFemale = other.getGivenNameFemale();
            if (this$givenNameFemale == null ? other$givenNameFemale != null : !this$givenNameFemale.equals(other$givenNameFemale)) {
                return false;
            }
            Generator<String> this$familyName = this.getFamilyName();
            Generator<String> other$familyName = other.getFamilyName();
            return !(this$familyName == null ? other$familyName != null : !this$familyName.equals(other$familyName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $country = this.getCountry();
            result = result * 59 + ($country == null ? 43 : $country.hashCode());
            Generator<String> $givenNameMale = this.getGivenNameMale();
            result = result * 59 + ($givenNameMale == null ? 43 : $givenNameMale.hashCode());
            Generator<String> $givenNameFemale = this.getGivenNameFemale();
            result = result * 59 + ($givenNameFemale == null ? 43 : $givenNameFemale.hashCode());
            Generator<String> $familyName = this.getFamilyName();
            result = result * 59 + ($familyName == null ? 43 : $familyName.hashCode());
            return result;
        }

        public String toString() {
            return "com.arboratum.beangen.extended.IdentityGeneratorBuilder.CountryConfig(country=" + this.getCountry() + ", givenNameMale=" + this.getGivenNameMale() + ", givenNameFemale=" + this.getGivenNameFemale() + ", familyName=" + this.getFamilyName() + ")";
        }

        public static class CountryConfigBuilder {
            private String country;
            private Generator<String> givenNameMale;
            private Generator<String> givenNameFemale;
            private Generator<String> familyName;

            CountryConfigBuilder() {
            }

            public CountryConfigBuilder country(String country) {
                this.country = country;
                return this;
            }

            public CountryConfigBuilder givenNameMale(Generator<String> givenNameMale) {
                this.givenNameMale = givenNameMale;
                return this;
            }

            public CountryConfigBuilder givenNameFemale(Generator<String> givenNameFemale) {
                this.givenNameFemale = givenNameFemale;
                return this;
            }

            public CountryConfigBuilder familyName(Generator<String> familyName) {
                this.familyName = familyName;
                return this;
            }

            public CountryConfig build() {
                return new CountryConfig(this.country, this.givenNameMale, this.givenNameFemale, this.familyName);
            }

            public String toString() {
                return "com.arboratum.beangen.extended.IdentityGeneratorBuilder.CountryConfig.CountryConfigBuilder(country=" + this.country + ", givenNameMale=" + this.givenNameMale + ", givenNameFemale=" + this.givenNameFemale + ", familyName=" + this.familyName + ")";
            }
        }
    }
}

