/*
 * Decompiled with CFR 0.152.
 */
package com.arboratum.beangen.util;

import com.google.common.util.concurrent.Uninterruptibles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongArray;

public class AtomicBitSet {
    private static final int ADDRESS_BITS_PER_WORD = 6;
    private static final int BITS_PER_WORD = 64;
    private static final int ADDRESS_BITS_PER_WORD_ATOMIC_ARRAY = 10;
    private static final int ATOMIC_LONG_ARRAY_SIZE = 1024;
    private final ConcurrentSkipListMap<Integer, AtomicLongArray> bitsHolderMap = new ConcurrentSkipListMap();

    private int getWordPos(int bitIndex) {
        return bitIndex >> 10;
    }

    private int getWordIndex(int bitIndex) {
        return (bitIndex & 0x3FF) >> 6;
    }

    private AtomicLongArray getBitsHolderFromMap(int bitIndex) {
        int wordPos = this.getWordPos(bitIndex);
        if (!this.bitsHolderMap.containsKey(wordPos)) {
            this.bitsHolderMap.putIfAbsent(wordPos, new AtomicLongArray(1024));
        }
        return this.bitsHolderMap.get(wordPos);
    }

    public boolean set(int bitIndex) {
        long newValue;
        long oldValue;
        AtomicLongArray bitsHolder = this.getBitsHolderFromMap(bitIndex);
        int arrIndex = this.getWordIndex(bitIndex);
        while (!bitsHolder.compareAndSet(arrIndex, oldValue = bitsHolder.get(arrIndex), newValue = oldValue | 1L << bitIndex)) {
        }
        return (oldValue >> bitIndex & 1L) == 1L;
    }

    public boolean get(int bitIndex) {
        int arrIndex;
        AtomicLongArray bitsHolder = this.getBitsHolderFromMap(bitIndex);
        long value = bitsHolder.get(arrIndex = this.getWordIndex(bitIndex)) >> bitIndex;
        return (value & 1L) == 1L;
    }

    public void waitClear(int bitIndex) {
        AtomicLongArray bitsHolder = this.getBitsHolderFromMap(bitIndex);
        int arrIndex = this.getWordIndex(bitIndex);
        while ((bitsHolder.get(arrIndex) >> bitIndex & 1L) == 1L) {
            Uninterruptibles.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    public void waitClearAndSet(int bitIndex) {
        long newValue;
        long oldValue;
        AtomicLongArray bitsHolder = this.getBitsHolderFromMap(bitIndex);
        int arrIndex = this.getWordIndex(bitIndex);
        do {
            oldValue = bitsHolder.get(arrIndex);
            while ((oldValue >> bitIndex & 1L) == 1L) {
                Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
                oldValue = bitsHolder.get(arrIndex);
            }
        } while (!bitsHolder.compareAndSet(arrIndex, oldValue, newValue = oldValue | 1L << bitIndex));
    }

    public List<Integer> getAllSetBits() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Map.Entry<Integer, AtomicLongArray> bitsHolderEntry : this.bitsHolderMap.entrySet()) {
            AtomicLongArray bitsHolder = bitsHolderEntry.getValue();
            for (int i = 0; i < bitsHolder.length(); ++i) {
                int j;
                int offset = bitsHolderEntry.getKey() * 1024;
                long value = bitsHolder.get(i);
                int max = j + 64;
                for (j = offset + i * 64; value != 0L && j < max; value >>= 1, ++j) {
                    if ((value & 1L) != 1L) continue;
                    result.add(j);
                }
            }
        }
        return result;
    }

    public int countSet() {
        int result = 0;
        for (Map.Entry<Integer, AtomicLongArray> bitsHolderEntry : this.bitsHolderMap.entrySet()) {
            AtomicLongArray bitsHolder = bitsHolderEntry.getValue();
            for (int i = 0; i < bitsHolder.length(); ++i) {
                int j;
                int offset = bitsHolderEntry.getKey() * 1024;
                long value = bitsHolder.get(i);
                int max = j + 64;
                for (j = offset + i * 64; value != 0L && j < max; value >>= 1, ++j) {
                    if ((value & 1L) != 1L) continue;
                    ++result;
                }
            }
        }
        return result;
    }

    public List<Integer> clearAndGetAllSetBits() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Map.Entry<Integer, AtomicLongArray> bitsHolderEntry : this.bitsHolderMap.entrySet()) {
            AtomicLongArray bitsHolder = bitsHolderEntry.getValue();
            for (int i = 0; i < bitsHolder.length(); ++i) {
                int j;
                int offset = bitsHolderEntry.getKey() * 1024;
                long oldValue = bitsHolder.get(i);
                while (!bitsHolder.compareAndSet(i, oldValue, 0L)) {
                    oldValue = bitsHolder.get(i);
                }
                int max = j + 64;
                for (j = offset + i * 64; oldValue != 0L && j < max; oldValue >>= 1, ++j) {
                    if ((oldValue & 1L) != 1L) continue;
                    result.add(j);
                }
            }
        }
        return result;
    }

    public void clearBits(int ... bitIndexList) {
        long newValue;
        long oldValue;
        AtomicLongArray bitsHolder;
        if (bitIndexList.length == 0) {
            return;
        }
        int prevBitIndex = bitIndexList[0];
        int prevWordPos = this.getWordPos(prevBitIndex);
        int prevArrIndex = this.getWordIndex(prevBitIndex);
        long helper = 1L << prevBitIndex;
        for (int i = 1; i < bitIndexList.length; ++i) {
            int currBitIndex = bitIndexList[i];
            int currWordPos = this.getWordPos(currBitIndex);
            int currArrIndex = this.getWordIndex(currBitIndex);
            if (currWordPos != prevWordPos || currArrIndex != prevArrIndex) {
                long newValue2;
                long oldValue2;
                AtomicLongArray bitsHolder2;
                while (!(bitsHolder2 = this.getBitsHolderFromMap(prevBitIndex)).compareAndSet(prevArrIndex, oldValue2 = bitsHolder2.get(prevArrIndex), newValue2 = oldValue2 & (helper ^ 0xFFFFFFFFFFFFFFFFL))) {
                }
                prevBitIndex = currBitIndex;
                prevWordPos = currWordPos;
                prevArrIndex = currArrIndex;
                helper = 0L;
            }
            helper |= 1L << currBitIndex;
        }
        while (!(bitsHolder = this.getBitsHolderFromMap(prevBitIndex)).compareAndSet(prevArrIndex, oldValue = bitsHolder.get(prevArrIndex), newValue = oldValue & (helper ^ 0xFFFFFFFFFFFFFFFFL))) {
        }
    }

    public boolean clear(int bitIndex) {
        long newValue;
        long oldValue;
        AtomicLongArray bitsHolder = this.getBitsHolderFromMap(bitIndex);
        int arrIndex = this.getWordIndex(bitIndex);
        while (!bitsHolder.compareAndSet(arrIndex, oldValue = bitsHolder.get(arrIndex), newValue = oldValue & (1L << bitIndex ^ 0xFFFFFFFFFFFFFFFFL))) {
        }
        return (oldValue >> bitIndex & 1L) == 1L;
    }

    public void clear() {
        for (AtomicLongArray bitsHolder : this.bitsHolderMap.values()) {
            for (int i = 0; i < bitsHolder.length(); ++i) {
                bitsHolder.set(i, 0L);
            }
        }
    }
}

