/*
 * Decompiled with CFR 0.152.
 */
package com.arboratum.beangen.util;

import java.util.concurrent.atomic.AtomicIntegerArray;

public class AtomicByteArray {
    private final AtomicIntegerArray array;
    private final int length;

    public AtomicByteArray(int length) {
        this.length = length;
        this.array = new AtomicIntegerArray((length + 3) / 4);
    }

    public void set(int i, byte newValue) {
        int num2;
        int num;
        int idx = i >>> 2;
        int shift = (i & 3) << 3;
        int mask = 255 << shift;
        int val2 = (newValue & 0xFF) << shift;
        while ((num = this.array.get(idx)) != (num2 = num & ~mask | val2) && !this.array.compareAndSet(idx, num, num2)) {
        }
    }

    public boolean compareAndSet(int i, byte expect, byte update) {
        int num2;
        int num;
        int idx = i >>> 2;
        int shift = (i & 3) << 3;
        int mask = 255 << shift;
        int expected2 = (expect & 0xFF) << shift;
        int val2 = (update & 0xFF) << shift;
        do {
            if (((num = this.array.get(idx)) & mask) == expected2) continue;
            return false;
        } while (num != (num2 = num & ~mask | val2) && !this.array.compareAndSet(idx, num, num2));
        return true;
    }

    public final byte getAndIncrement(int i) {
        return this.getAndAdd(i, 1);
    }

    public final byte getAndDecrement(int i) {
        return this.getAndAdd(i, -1);
    }

    public final byte getAndAdd(int i, int delta) {
        byte next;
        byte current;
        while (!this.compareAndSet(i, current = this.get(i), next = (byte)(current + delta))) {
        }
        return current;
    }

    public final byte incrementAndGet(int i) {
        return this.addAndGet(i, 1);
    }

    public final byte decrementAndGet(int i) {
        return this.addAndGet(i, -1);
    }

    public final byte addAndGet(int i, int delta) {
        byte next;
        byte current;
        while (!this.compareAndSet(i, current = this.get(i), next = (byte)(current + delta))) {
        }
        return next;
    }

    public byte get(int i) {
        return (byte)(this.array.get(i >>> 2) >> ((i & 3) << 3));
    }

    public int length() {
        return this.length;
    }
}

