/*
 * Decompiled with CFR 0.152.
 */
package com.arboratum.beangen.util;

import com.arboratum.beangen.core.EnumeratedDistributionGeneratorBuilder;
import com.google.common.io.Resources;
import com.google.common.primitives.Longs;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.apache.commons.math3.stat.Frequency;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Pair;

public final class DistributionUtils {
    public static <K extends Comparable<K>> Frequency convert(Map<K, ? extends Number> counts) {
        Frequency frequency = new Frequency();
        for (Map.Entry<K, Number> c : counts.entrySet()) {
            frequency.incrementValue((Comparable)c.getKey(), c.getValue().longValue());
        }
        return frequency;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Frequency fromCsvResource(String resource) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(DistributionUtils.getResourceAsStream(resource), "UTF-8"));){
            Frequency frequency = reader.lines().map(String::trim).filter(line -> !line.isEmpty() && !line.startsWith("#")).map(line -> line.split(",")).map(tokens -> {
                Long count = null;
                if (((String[])tokens).length >= 2) {
                    count = Longs.tryParse((String)tokens[1]);
                }
                return new Pair((Object)tokens[0], (Object)(count == null ? 1L : count));
            }).collect(Frequency::new, (r, p) -> r.incrementValue((Comparable)p.getKey(), ((Long)p.getValue()).longValue()), Frequency::merge);
            return frequency;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("invalid resource file :" + resource, e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid resource file :" + resource, e);
        }
    }

    public static <K extends Comparable<K>> Frequency filter(Frequency source, Predicate<K> predicate) {
        Frequency frequency = new Frequency();
        source.entrySetIterator().forEachRemaining(entry -> {
            Comparable key = (Comparable)entry.getKey();
            if (predicate.test(key)) {
                frequency.incrementValue(key, ((Long)entry.getValue()).longValue());
            }
        });
        return frequency;
    }

    public static <K1 extends Comparable<K1>, K2 extends Comparable<K2>, K extends Comparable<K>> Frequency join(Frequency source1, Frequency source2, BiFunction<K1, K2, K> keyJoin) {
        Frequency frequency = new Frequency();
        source1.entrySetIterator().forEachRemaining(e1 -> {
            Comparable k1 = (Comparable)e1.getKey();
            source2.entrySetIterator().forEachRemaining(e2 -> {
                Comparable k2 = (Comparable)e2.getKey();
                long increment = FastMath.multiplyExact((long)((Long)e1.getValue()), (long)((Long)e2.getValue()));
                frequency.incrementValue((Comparable)keyJoin.apply(k1, k2), increment);
            });
        });
        return frequency;
    }

    private static InputStream getResourceAsStream(String resource) throws IOException {
        InputStream resourceAsStream = Resources.getResource(EnumeratedDistributionGeneratorBuilder.class, (String)resource).openStream();
        if (resourceAsStream == null) {
            throw new IllegalArgumentException("Resource not found : " + resource);
        }
        return resourceAsStream;
    }
}

