/*
 * Decompiled with CFR 0.152.
 */
package com.arboratum.beangen.util;

import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.Spliterators;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;

public class IntSequence {
    private final int[] data;

    public IntSequence(int[] data, boolean nocopy) {
        this.data = nocopy ? data : Arrays.copyOf(data, data.length);
    }

    public IntSequence(int[] data, int offset, int count) {
        this.data = Arrays.copyOfRange(data, offset, count);
    }

    public IntSequence(int[] data) {
        this(data, false);
    }

    public int length() {
        return this.data.length;
    }

    public int intAt(int index) {
        return this.data[index];
    }

    public IntSequence subSequence(int start, int end) {
        return new IntSequence(this.data, start, end - start);
    }

    public IntSequence concat(IntSequence other) {
        int otherLen = other.length();
        if (otherLen == 0) {
            return this;
        }
        int len = this.data.length;
        int[] buf = Arrays.copyOf(this.data, len + otherLen);
        System.arraycopy(other.data, 0, buf, len, otherLen);
        return new IntSequence(buf, true);
    }

    public String toString() {
        return Arrays.toString(this.data);
    }

    public IntStream ints() {
        return StreamSupport.intStream(() -> {
            class IntIterator
            implements PrimitiveIterator.OfInt {
                int cur = 0;

                IntIterator() {
                }

                @Override
                public boolean hasNext() {
                    return this.cur < IntSequence.this.length();
                }

                @Override
                public int nextInt() {
                    if (this.hasNext()) {
                        return IntSequence.this.intAt(this.cur++);
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void forEachRemaining(IntConsumer block) {
                    while (this.cur < IntSequence.this.length()) {
                        block.accept(IntSequence.this.intAt(this.cur));
                        ++this.cur;
                    }
                }
            }
            return Spliterators.spliterator(new IntIterator(), (long)this.length(), 16);
        }, 16464, false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntSequence that = (IntSequence)o;
        return Arrays.equals(this.data, that.data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public int[] toArray() {
        return Arrays.copyOf(this.data, this.data.length);
    }
}

