/*
 * Decompiled with CFR 0.152.
 */
package com.arboratum.beangen.util;

public abstract class LoremIpsum {
    public static final String LOREM_IPSUM = "Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.";
    private static final String[] loremIpsumWords = "Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est Lorem ipsum dolor sit amet.".split("\\s");

    public static String getWords() {
        return LoremIpsum.getWords(50);
    }

    public static String getWords(int amount) {
        return LoremIpsum.getWords(amount, 0);
    }

    public static String getWords(int amount, int startIndex) {
        if (startIndex < 0 || startIndex > 49) {
            throw new IndexOutOfBoundsException("startIndex must be >= 0 and < 50");
        }
        int word = startIndex;
        StringBuilder lorem = new StringBuilder();
        for (int i = 0; i < amount; ++i) {
            if (word == 50) {
                word = 0;
            }
            lorem.append(loremIpsumWords[word]);
            if (i < amount - 1) {
                lorem.append(' ');
            }
            ++word;
        }
        return lorem.toString();
    }

    public static String getParagraphs() {
        return LoremIpsum.getParagraphs(2);
    }

    public static String getParagraphs(int amount) {
        StringBuilder lorem = new StringBuilder();
        for (int i = 0; i < amount; ++i) {
            lorem.append(LOREM_IPSUM);
            if (i >= amount - 1) continue;
            lorem.append("\n\n");
        }
        return lorem.toString();
    }
}

