/*
 * Decompiled with CFR 0.152.
 */
package com.arboratum.beangen.util;

import com.arboratum.beangen.Generator;
import com.arboratum.beangen.util.IntSequence;
import com.arboratum.beangen.util.RandomSequence;
import com.google.common.collect.Streams;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import reactor.core.publisher.Flux;
import reactor.core.publisher.SynchronousSink;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class MathUtils {
    public static final Collector<Tuple2<Integer, Long>, ?, TreeMap<Integer, BitSet>> TO_INVERTED_INDEX = Collectors.groupingBy(Tuple2::getT1, TreeMap::new, Collector.of(BitSet::new, (bitSet, o) -> bitSet.set(((Long)o.getT2()).intValue()), (bitSet, bitSet2) -> {
        bitSet.or((BitSet)bitSet2);
        return bitSet;
    }, new Collector.Characteristics[0]));

    public static void randomPermutation(int[] array, RandomSequence randomSequence) {
        int n = array.length;
        for (int i = 0; i < n - 1; ++i) {
            int j = randomSequence.nextInt(n - i);
            MathUtils.swap(array, i, i + j);
        }
    }

    private static void swap(int[] array, int i, int j) {
        int tmp = array[i];
        array[i] = array[j];
        array[j] = tmp;
    }

    public static Generator<IntSequence> randomSubSetSum(final int total, final int numUniquewanted, final RandomSequence randomSequence, final SubSetSumIndex subSetSumIndex) {
        if (subSetSumIndex.getIndex()[total].length == 0) {
            return new Generator<IntSequence>(IntSequence.class){

                @Override
                public IntSequence generate(RandomSequence register) {
                    return null;
                }
            };
        }
        return new Generator<IntSequence>(IntSequence.class){
            private ArrayList<IntSequence> cachedSequences;
            private HashSet<IntSequence> cachedSequencesSet;
            private volatile int cached;
            private volatile boolean noMore;
            {
                super(type);
                this.cachedSequences = new ArrayList();
                this.cachedSequencesSet = new HashSet();
                this.cached = 0;
                this.noMore = false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IntSequence generate(RandomSequence register) {
                if (this.noMore && this.cached == 0) {
                    return null;
                }
                int nth = register.nextInt(this.noMore ? this.cached : numUniquewanted);
                if (nth < this.cached) {
                    return this.cachedSequences.get(nth);
                }
                IntSequence e = null;
                int[] buffer = new int[total];
                ArrayList<IntSequence> arrayList = this.cachedSequences;
                synchronized (arrayList) {
                    if (nth < this.cached) {
                        return this.cachedSequences.get(nth);
                    }
                    for (int trial = 0; trial < numUniquewanted * 10 && this.cached <= nth; ++trial) {
                        int weigthI;
                        int i = 0;
                        for (int S = total; i < buffer.length && S > 0; S -= subSetSumIndex.getWeights()[weigthI], ++i) {
                            int[] map = subSetSumIndex.getIndex()[S];
                            buffer[i] = weigthI = map[randomSequence.nextInt(map.length)];
                        }
                        e = new IntSequence(buffer, 0, i);
                        if (!this.cachedSequencesSet.add(e)) continue;
                        this.cachedSequences.add(e);
                        ++this.cached;
                    }
                    if (e == null) {
                        this.noMore = true;
                        this.cachedSequencesSet = null;
                        if (this.cached > 0) {
                            return this.cachedSequences.get(nth % this.cached);
                        }
                        return null;
                    }
                    if (this.cached == numUniquewanted) {
                        this.noMore = true;
                        this.cachedSequencesSet = null;
                    }
                    return e;
                }
            }
        };
    }

    public static class SubSetSumIndex {
        private int[] weights;
        private int total = 0;
        private int[][] index;
        private BigInteger[] counts;

        public SubSetSumIndex(int[] weights) {
            this.weights = weights;
        }

        public int[][] getIndex() {
            return this.index;
        }

        public SubSetSumIndex rebuild(int total) {
            if (total <= this.total) {
                return this;
            }
            TreeMap<Integer, BitSet> invertedIndexByWeightValue = Streams.mapWithIndex((IntStream)Arrays.stream(this.weights), Tuples::of).collect(TO_INVERTED_INDEX);
            int[][] index = new int[total + 1][];
            index[0] = new int[0];
            BigInteger[] counts = new BigInteger[total + 1];
            counts[0] = BigInteger.ZERO;
            for (int subtotal = 1; subtotal < index.length; ++subtotal) {
                Map.Entry<Integer, BitSet> e;
                int weight;
                BitSet possibilities = new BitSet();
                BigInteger count = BigInteger.ZERO;
                Iterator<Map.Entry<Integer, BitSet>> iterator = invertedIndexByWeightValue.entrySet().iterator();
                while (iterator.hasNext() && (weight = (e = iterator.next()).getKey().intValue()) <= subtotal) {
                    BigInteger subcount;
                    BitSet correspondingElements = e.getValue();
                    if (weight == subtotal) {
                        possibilities.or(correspondingElements);
                        count = count.add(BigInteger.valueOf(correspondingElements.cardinality()));
                        continue;
                    }
                    if (index[subtotal - weight].length != 0) {
                        possibilities.or(correspondingElements);
                    }
                    if ((subcount = counts[subtotal - weight]).equals(BigInteger.ZERO)) continue;
                    count = count.add(BigInteger.valueOf(correspondingElements.cardinality()).multiply(subcount));
                }
                counts[subtotal] = count;
                index[subtotal] = possibilities.stream().toArray();
            }
            this.index = index;
            this.total = total;
            this.counts = counts;
            return this;
        }

        public int[] getWeights() {
            return this.weights;
        }

        public BigInteger[] getCounts() {
            return this.counts;
        }

        public Flux<IntSequence> allCombinations(int sum) {
            if (sum == 0) {
                return Flux.empty();
            }
            int[] localWeights = this.weights;
            int[][] localIndex = this.index;
            return this.allCombRecursive(sum, localWeights, localIndex);
        }

        private Flux<IntSequence> allCombRecursive(int sum, int[] localWeights, int[][] localIndex) {
            int[] localIndexAtSum = localIndex[sum];
            return Flux.range((int)0, (int)localIndexAtSum.length).map(i -> new IntSequence(new int[]{localIndexAtSum[i]}, true)).concatMap(left -> {
                int weight = localWeights[left.intAt(0)];
                if (weight == sum) {
                    return Flux.just((Object)left);
                }
                return this.allCombRecursive(sum - weight, localWeights, localIndex).map(right -> left.concat((IntSequence)right));
            });
        }

        public Flux<IntSequence> randomSolutions(RandomSequence randomSequence, final int sum) {
            final int[][] index = this.getIndex();
            final int[] weights = this.getWeights();
            final RandomSequence localSequence = new RandomSequence(randomSequence.nextLong(Long.MAX_VALUE));
            return Flux.generate((Consumer)new Consumer<SynchronousSink<IntSequence>>(){
                final int[] buffer;
                {
                    this.buffer = new int[sum];
                }

                @Override
                public void accept(SynchronousSink<IntSequence> synchronousSink) {
                    int weigthI;
                    int i = 0;
                    for (int S = sum; i < this.buffer.length && S > 0; S -= weights[weigthI], ++i) {
                        int[] map = index[S];
                        this.buffer[i] = weigthI = map[localSequence.nextInt(map.length)];
                    }
                    synchronousSink.next((Object)new IntSequence(this.buffer, 0, i));
                }
            });
        }
    }
}

