/*
 * Decompiled with CFR 0.152.
 */
package com.arboratum.beangen.util;

import java.util.function.IntSupplier;
import java.util.stream.IntStream;
import org.roaringbitmap.RoaringBitmap;

public strictfp class RandomSequence {
    private final long seed;
    private long register;
    private static final long MASK_31_BITS = Integer.MAX_VALUE;
    private static final long MASK_63_BITS = Long.MAX_VALUE;
    private static final long DOUBLE_MASK = 0x1FFFFFFFFFFFFFL;
    public static final double DOUBLE_STEP = (double)1.110223E-16f;
    private static final long FLOAT_MASK = 0xFFFFFFL;
    private static final float FLOAT_STEP = 5.9604645E-8f;

    private RandomSequence(long seed, long register) {
        this.seed = seed;
        this.register = register;
    }

    public RandomSequence(long id) {
        this.seed = id;
        if (id < 0L) {
            throw new IllegalArgumentException("only positive id are supported");
        }
        do {
            id += 17L;
            id ^= id << 21;
            id ^= id >>> 35;
        } while (Long.bitCount(id ^= id << 4) < 20);
        this.register = id;
    }

    private final long shift(long x) {
        x ^= x >> 12;
        x ^= x << 25;
        x ^= x >> 27;
        return x * 2685821657736338717L;
    }

    public long nextLong() {
        this.register = this.shift(this.register);
        return this.register;
    }

    public int nextInt() {
        this.register = this.shift(this.register);
        return (int)this.register;
    }

    public int nextInt(int n) {
        if (n > 0) {
            int val;
            int bits;
            if ((n & -n) == n) {
                long bits2 = this.register = this.shift(this.register);
                return (int)((long)n * (bits2 & Integer.MAX_VALUE) >> 31);
            }
            long x = this.register;
            while ((bits = (int)((x = this.shift(x)) & Integer.MAX_VALUE)) - (val = bits % n) + (n - 1) < 0) {
            }
            this.register = x;
            return val;
        }
        throw new IllegalArgumentException("Not positive");
    }

    public long nextLong(long bound) {
        long x;
        long r = x = this.shift(this.register);
        long n = bound;
        long m = n - 1L;
        if ((n & m) == 0L) {
            r &= m;
        } else if (n > 0L) {
            long u = r >>> 1;
            while (u + m - (r = u % n) < 0L) {
                x = this.shift(x);
                u = x >>> 1;
            }
        } else {
            while (r < 0L || r >= bound) {
                r = x = this.shift(x);
            }
        }
        this.register = x;
        return r;
    }

    public double nextDouble() {
        long bits = this.register = this.shift(this.register);
        return (double)(bits >>> 11) * (double)1.110223E-16f;
    }

    private long next(int nbits) {
        long bits = this.register = this.shift(this.register);
        bits <<= 64 - nbits;
        return bits >>>= nbits;
    }

    public float nextFloat() {
        long bits = this.register = this.shift(this.register);
        return (float)(bits & 0xFFFFFEL) * 5.9604645E-8f;
    }

    public boolean nextBoolean() {
        this.register = this.shift(this.register);
        long bits = this.register;
        return bits > 0L;
    }

    public void nextBytes(byte[] bytes) {
        int i = 0;
        int len = bytes.length;
        while (i < len) {
            long rnd = this.nextLong();
            long n = Math.min(len - i, 8);
            while (n-- > 0L) {
                bytes[i++] = (byte)rnd;
                rnd >>= 8;
            }
        }
    }

    public long getSeed() {
        return this.seed;
    }

    public long getRegister() {
        return this.register;
    }

    public IntStream randomWalk(final int fromInclusive, final int toExclusive) {
        final RoaringBitmap set = new RoaringBitmap();
        set.add(fromInclusive, toExclusive);
        return IntStream.generate(new IntSupplier(){
            int remaining;
            {
                this.remaining = toExclusive - fromInclusive;
            }

            @Override
            public int getAsInt() {
                int select = set.select(RandomSequence.this.nextInt(this.remaining));
                set.remove(select);
                --this.remaining;
                return select;
            }
        }).limit(toExclusive - fromInclusive);
    }

    public RandomSequence fork() {
        this.register = this.shift(this.register);
        return new RandomSequence(this.seed, this.register);
    }
}

